 ;
 ; ===========================================================
 ;  \Win32ASM\Src\RAT\s.asm
 ; ===========================================================
 ;                      Adam Baszczyk
 ;              "Win32ASM. Asembler w Windows"
 ;                Wydawnictwo Helion, 2004
 ; ===========================================================
 ;  Kompilacja : "r.bat", "d.bat", "nmake"
 ;  Opis       : Ko trojaski w Win32ASM - serwer
 ; ===========================================================

 include wspolne.inc

 POLECENIE STRUCT
  ptrS dd ?
  ptrP dd ?
 POLECENIE ENDS

.data
 hKlient     dd 0
 koniecPracy dd 0

 szKalkulator    db 'calc.exe',NULL
 szOtworz        db 'set cdaudio door open wait',NULL
 szZamknij       db 'set cdaudio door closed wait',NULL
 szPowitanie     db 'Czesc! Serwer dziala =)',NULL

 fxTEST          db 'TEST',NULL
 fxZAMKNIJ       db 'ZAMKNIJ',NULL
 fxKALKULATOR    db 'KALKULATOR',NULL
 fxZART          db 'ZART',NULL

 pxNieznane      proto
 pxTEST          proto
 pxZAMKNIJ       proto
 pxKALKULATOR    proto
 pxZART          proto

 ZdefPolecenia label dword
  POLECENIE <OFS fxTEST       ,OFS pxTEST>
  POLECENIE <OFS fxZAMKNIJ    ,OFS pxZAMKNIJ>
  POLECENIE <OFS fxKALKULATOR ,OFS pxKALKULATOR>
  POLECENIE <OFS fxZART       ,OFS pxZART>
 ILE_JEST_POLECEN = ($-OFS ZdefPolecenia)/SIZEOF POLECENIE

.code

 ;;;; menader procedur obsugujcych protok
 WykonajPolecenie proc polecenie:DWORD
   mov   ecx,ILE_JEST_POLECEN
   lea   ebx,ZdefPolecenia

  WykPetla:
   push   ecx
   push   ebx
   INV    lstrcmpi,[ebx.POLECENIE.ptrS],polecenie
   pop    ebx
   pop    ecx
   .if   eax==0
         call DPTR [ebx.POLECENIE.ptrP]
         mov  ecx,1
         xor  eax,eax
   .endif
   add    ebx,SIZEOF POLECENIE

   loop     WykPetla
   .if eax!=0
       INV    pxNieznane
   .endif
   ret
 WykonajPolecenie endp

 ;;;; procedury, ktre obsuguj protok
 pxNieznane proc
  LOG "-------> Polecenie nieznane"
  ret
 pxNieznane endp

 pxTEST proc
  LOG "-------> Test serwera"
  INV    WyslijPolecenie,hKlient,OFS szPowitanie
  ret
 pxTEST endp

 pxZAMKNIJ proc
  LOG "-------> Zamknij serwer"
  mov koniecPracy,TRUE
  ret
 pxZAMKNIJ endp

 pxZART proc
  LOG "-------> Zart"
  INV    mciSendString,OFS szOtworz,NULL,NULL,NULL
  INV    mciSendString,OFS szZamknij,NULL,NULL,NULL
  ret
 pxZART endp

 pxKALKULATOR proc
  LOG "-------> Uruchom Kalkulator"
   INV    ShellExecute,0,NULL,OFS szKalkulator,NULL,0,SW_SHOWNORMAL
  ret
 pxKALKULATOR endp

 ;;;; procedura zamyka gniazdka (jeli s otwarte)
 ZamknijGniazdko proc
   .if hGniazdko!=0
       INV    closesocket,hGniazdko
       mov    hGniazdko,0
   .endif
   .if hKlient!=0
       INV    closesocket,hKlient
       mov    hKlient,0
   .endif
   ret
 ZamknijGniazdko endp

  ;;;; wtek, ktry dziaa jako serwer
 Serwer proc parametr:DWORD
  LOCAL SockAddr:sockaddr_in
  LOCAL SockAddrLen:DWORD
  LOCAL addrIP:DWORD
  LOCAL szIP[32]:BYTE
  LOCAL szPolecenie[128]:BYTE
  LOCAL ddPort:DWORD
  LOCAL ddPortOdp:DWORD

  LOG "Serwer::Poczatek"
   mov    koniecPracy,FALSE
   INV    GetDlgItemInt,hOkno,IDE_PORT,ADDR ddPortOdp,0
   mov    ddPort,eax

   LOG "Serwer::gethostname"
   INV    gethostname,ADDR szIP,SIZEOF szIP
    ERROR eax,0,JNE,Serwer_ret

   INV    GetDlgItemText,hOkno,IDE_IP,ADDR szIP,SIZEOF szIP

  LOG "Serwer::gethostbyname"
   INV    gethostbyname,ADDR szIP
    ERROR eax,0,JE,Serwer_ret

   cld
   lea esi,dword ptr [eax+hostent.h_len]
   lea edi,addrIP
   lodsw
   movzx ecx,ax
   lodsd
   mov esi,dword ptr [eax]
   rep movsb
			
   ; w praktyce, powyszy kod jest rwnowany temu:
   ; mov    eax,dword ptr [eax+hostent.h_list]	
   ; mov    eax,[eax]                          
   ; mov    eax,[eax]                          	
	  ; mov    addrIP,eax                        		

  LOG "Serwer::inet_ntoa"
   INV    inet_ntoa,addrIP
    ERROR eax,INADDR_NONE,JE,Serwer_ret
   INV    lstrcpy,ADDR szIP,eax

   INV    SetDlgItemText,hOkno,IDE_IP,ADDR szIP

    LOG "Serwer::socket"
   INV    socket,AF_INET,SOCK_STREAM,0
   mov    hGniazdko,eax
    ERROR eax,INVALID_SOCKET,JE,Serwer_ret

  LOG "Serwer::htons"
   INV    htons,ddPort
   mov    [SockAddr.sin_port],ax
   mov    [SockAddr.sin_family],AF_INET
   mov    [SockAddr.sin_addr],INADDR_ANY

  LOG "Serwer::bind"
   INV    bind,hGniazdko,ADDR SockAddr,SIZEOF SockAddr
  LOG "Serwer::listen"
   INV    listen,hGniazdko,1
    ERROR eax,0,JNE,Serwer_ret
 PetlaSerwera:
  LOG "Serwer::accept"
   mov    SockAddrLen,SIZEOF SockAddr
   INV    accept,hGniazdko,ADDR SockAddr,ADDR SockAddrLen
    ERROR eax,INVALID_SOCKET,JE,Serwer_ret
   mov    hKlient,eax
  LOG "Serwer::CzytajPolecenie"
   INV    CzytajPolecenie,hKlient,ADDR szPolecenie,SIZEOF szPolecenie
  LOG "Serwer::WykonajPolecenie"
   INV    WykonajPolecenie,ADDR szPolecenie
  LOG "Serwer::closesocket-hKlient"
   INV    closesocket,hKlient
   mov    hKlient,0

   cmp    koniecPracy,TRUE
   jne    PetlaSerwera

  Serwer_ret:
  LOG "Serwer::ZamknijGniazdko"
   INV    ZamknijGniazdko

  LOG "Serwer::Koniec"
  LOG "-----------------"
   ret
 Serwer endp
 
 ;;;; procedura koczy prac serwera
 ZamknijSerwer proc
   .if hWatek!=NULL
       LOG "proc::ZamknijSerwer"
       INV    ZamknijGniazdko
       LOG "proc::TerminateThread"
       INV    TerminateThread,hWatek,0
       LOG "proc::CloseHandle"
       INV    CloseHandle,hWatek
       mov    hWatek,NULL
   .endif
   ret
 ZamknijSerwer endp
 
 ;;;; procedura uruchamia serwer
 UruchomSerwer proc
   INV    ZamknijSerwer
   LOG "proc::UruchomSerwer"
   LOG "proc::CreateThread"
   INV    CreateThread,NULL,0,OFS Serwer,0,0,OFS hWatekID
   mov    hWatek,eax
   ret
 UruchomSerwer endp
 
 ;;;; procedura obsugi okna dialogu
 DlgProc proc hDlg:DWORD,uMsg:DWORD,wParam:DWORD,lParam:DWORD
       ; -- inicjalizacja okna dialogu
   .if uMsg==WM_INITDIALOG
       INV    SetWindowPos,hDlg,0,0,0,0,0,SWP_NOSIZE or SWP_NOZORDER

       mov    eax,hDlg
       mov    hOkno,eax

       INV    GetDlgItem,hDlg,IDLB_LOGI
       mov    hLogi,eax

       INV    SetDlgItemText,hDlg,IDE_IP,OFS TxLocalhost
       INV    SetDlgItemInt,hDlg,IDE_PORT,PORT_SERWERA,FALSE

       ; -- zamykanie okna dialogu
   .elseif  uMsg==WM_CLOSE
       INV    ZamknijSerwer
       INV    EndDialog,hDlg,0

       ; -- obsuga przyciskw
   .elseif  uMsg==WM_COMMAND
          ; -- obsuga przycisku [Koniec]
      .if wParam==IDB_KONIEC
          INV    SendMessage,hDlg,WM_CLOSE,0,0
          ; -- obsuga przycisku [Uruchom serwer]
      .elseif wParam==IDB_URUCHOM
          INV    UruchomSerwer
          ; -- obsuga przycisku [Czy Logi]
      .elseif wParam==IDB_CZYSCLOGI
          INV    SendMessage,hLogi,LB_RESETCONTENT,0,0
      .endif
   .endif
   xor eax, eax
   ret
 DlgProc endp

 ;;;; program gwny
 WinMain proc
  LOCAL wsadata:WSADATA
   INV    GetModuleHandle,NULL
   mov    hInstance,eax

  VERSION1_1 = 00000101h
   INV    WSAStartup,VERSION1_1,ADDR wsadata
   .if eax==0 && WPTR [wsadata.wVersion]==VERSION1_1
       INV    DialogBoxParam,hInstance,IDD_SERWER,0,ADDR DlgProc,0
   .endif
   INV    WSACleanup
   ret
 WinMain endp

 ;;;; start programu 
 Start:
   INV    WinMain
   INV    ExitProcess,0

END Start

