 ;
 ; ===========================================================
 ;  \Win32ASM\Src\Magnetic\Magnetic.asm
 ; ===========================================================
 ;                      Adam Baszczyk
 ;              "Win32ASM. Asembler w Windows"
 ;                Wydawnictwo Helion, 2004
 ; ===========================================================
 ;  Kompilacja : "r.bat", "d.bat", "nmake"
 ;  Opis       : Magnetyczne okno, ktre jest "przycigane" do
 ;               krawdzi ekranu i granic obszaru roboczego
 ;               Pulpitu
 ; ===========================================================

 include ..\..\makro.inc       ; doczamy definicje makr

 INCLUDEX kernel32             ; uywamy KERNEL32
 INCLUDEX user32               ; uywamy USER32

 ID_DLG_MAIN   = 100
 ID_CHANGE     = 1002

.data?                         ; dane niezainicjalizowane
 hInstance dd ?
 scrW      dd ?
 scrH      dd ?
 wa       RECT <>

.data                          ; dane zainicjalizowane
 bMagnet    dd TRUE
 szNormal   db 'Wcz magnes.. ',NULL
 szMagnes   db 'Wycz magnes..',NULL
 magX       dd 10
 magY       dd 10

.code                          ; segment kodu (sekcja kodu)
   DlgProc proc hDlg,uMsg,wParam,lParam:DWORD
    LOCAL rc:RECT
    LOCAL dlgW,dlgH;DWORD
     pushad

     .IF  uMsg==WM_CLOSE
       INV EndDialog,hDlg,0

     .ELSEIF uMsg==WM_INITDIALOG
        INV    GetSystemMetrics,SM_CXSCREEN
        mov    scrW,eax
        INV    GetSystemMetrics,SM_CYSCREEN
        mov    scrH,eax

        INV    SystemParametersInfo,SPI_GETWORKAREA,0,ADDR wa,0

        INV    SetDlgItemText,hDlg,ID_CHANGE,OFS szMagnes

     .ELSEIF uMsg==WM_WINDOWPOSCHANGING
       .IF bMagnet==TRUE
          mov    edi,lParam
          mov    edx,[edi.WINDOWPOS.y]
          mov    eax,[edi.WINDOWPOS.x]
          MOM   dlgW,[edi.WINDOWPOS.lx]
          MOM   dlgH,[edi.WINDOWPOS.cy]

           ; X: sprawdzamy od 1 do magX
          .IF (SGND eax>0)&&(SGND eax<=magX)
            xor eax,eax
          .ENDIF

           ; X: sprawdzamy od wa.left+1 do wa.left+magX
          mov    ecx,wa.left
          add    ecx,magX
          .IF (SGND eax>wa.left)&&(SGND eax<=ecx)
            mov eax,wa.left
          .ENDIF

           ; Y: sprawdzamy od 1 do magY
          .IF (SGND edx>0)&&(SGND edx<=magY)
            xor edx,edx
          .ENDIF

           ; Y: sprawdzamy od wa.top+1 do wa.top+magY
          mov    ecx,wa.top
          add    ecx,magY
          .IF (SGND edx>wa.top)&&(SGND edx<=ecx)
            mov edx,wa.top
          .ENDIF

           ; X: sprawdzamy wa.right-dlgW-magX do wa.right-dlgW
          mov    ebx,wa.right
          sub    ebx,dlgW
          mov    ecx,ebx
          sub    ebx,magX
          .IF (SGND eax>=ebx)&&(SGND eax<ecx)
            mov    eax,ecx
          .ENDIF

           ; X: sprawdzamy scrW-dlgW-magX do scrW-dlgW
          mov    ebx,scrW
          sub    ebx,dlgW
          mov    ecx,ebx
          sub    ebx,magX
          .IF (SGND eax>=ebx)&&(SGND eax<ecx)
            mov    eax,ecx
          .ENDIF

           ; Y: sprawdzamy wa.bottom-dlgH-magY do wa.bottom-dlgH
          mov    ebx,wa.bottom
          sub    ebx,dlgH
          mov    ecx,ebx
          sub    ebx,magY
          .IF (SGND edx>=ebx)&&(SGND edx<ecx)
            mov    edx,ecx
          .ENDIF

           ; Y: sprawdzamy scrH-dlgH-magY do scrH-dlgH
          mov    ebx,scrH
          sub    ebx,dlgH
          mov    ecx,ebx
          sub    ebx,magY
          .IF (SGND edx>=ebx)&&(SGND edx<ecx)
            mov    edx,ecx
          .ENDIF

          mov  [edi.WINDOWPOS.y],edx
          mov  [edi.WINDOWPOS.x],eax

       .ENDIF
     .ELSEIF uMsg==WM_COMMAND

       .IF wParam==IDOK
          INV SendMessage,hDlg,WM_CLOSE,0,0

       .ELSEIF wParam==ID_CHANGE
          inc   bMagnet      ; \ na przemian wczony/
          and   bMagnet,1    ; / wyczony

          mov   eax,bMagnet  ; eax=0 or 1
          shl   eax,4
          lea   eax,[eax+OFS szNormal]

          INV SetDlgItemText,hDlg,ID_CHANGE,eax
        .ENDIF

     .ENDIF

     popad
     xor eax,eax
     ret
   DlgProc endp

   Start:                      ; pocztek programu

     INV GetModuleHandle,NULL
     mov hInstance,eax

     INV DialogBoxParam,hInstance,ID_DLG_MAIN,0,ADDR DlgProc,0

     INV ExitProcess,0      ; zakoczenie programu

END Start                   ; tu zaczyna si program
