 ;
 ; ===========================================================
 ;  \Win32ASM\Src\Edytor\Edytor2.asm
 ; ===========================================================
 ;                      Adam Baszczyk
 ;              "Win32ASM. Asembler w Windows"
 ;                Wydawnictwo Helion, 2004
 ; ===========================================================
 ;  Kompilacja : "r.bat", "d.bat", "nmake"
 ;  Opis       : Prymitywny edytor w Win32ASM
 ; ===========================================================

 include ..\..\makro.inc       ; doczamy definicje makr

 INCLUDEX kernel32             ; uywamy KERNEL32
 INCLUDEX user32               ; uywamy USER32
 INCLUDEX Comdlg32             ; uywamy Comdlg32

 DLG_EDYTOR  = 100
 ID_EDYTOR   = 101
 ID_NOWY     = 1010
 ID_OTWORZ   = 1020
 ID_ZAPISZ   = 1030
 ID_ZAKONCZ  = 1050
	
	OFN_ENABLESIZING    = 00800000h
	OFN_FORCESHOWHIDDEN = 10000000h
 
.data?                         ; dane niezainicjalizowane
 hIns     dd ?
 oofn OPENFILENAME <>
 sofn OPENFILENAME <> 
 bufor     db 30000 dup(?)    ; \ maksymalna liczba znakw, 
                              ; | ktre moe pomieci
                              ; / kontrolka EDITBOX

.data                         ; dane zainicjalizowane
 nic     db NULL
 edytor  db 'Edytor',NULL
 zapisOK db 'Plik zapisany poprawnie',NULL
 ; Open
 ofilter     db 'Pliki tekstowe' ,NULL,'*.txt',NULL
             db 'Wszystkie pliki',NULL,'*.*'  ,NULL
             db NULL
 ocustFilter db 256 dup(NULL)
 ofname      db 'tekst.txt',NULL
             db 256 dup (NULL)
 oftitle     db 256 dup (NULL)
 oinitDir    db 'C:\Win32ASM\Src\Edytor',NULL
 odlgTitle   db 'Otwrz plik tekstowy...',NULL
 ; Save As
 sfilter     db 'Pliki tekstowe' ,NULL,'*.txt',NULL
             db 'Wszystkie pliki',NULL,'*.*'  ,NULL
             db NULL
 scustFilter db 256 dup(NULL)
 sfname      db 'zapisywanytekst.txt',NULL
             db 256 dup (NULL)
 sftitle     db 256 dup (NULL)
 sinitDir    db 'C:\Win32ASM\Src\Edytor',NULL
 sdlgTitle   db 'Zapisz plik tekstowy...',NULL
 
.code                          ; segment kodu (sekcja kodu)
   DlgProc proc hDlg,uMsg,wParam,lParam:DWORD
    LOCAL hFile:DWORD
    LOCAL xRead,xWrite:DWORD         
      ;;; kod dodany ju po wydrukowaniu ksiki
    LOCAL rc:RECT
      ;;; kod dodany ju po wydrukowaniu ksiki
  
     pushad

     .IF  uMsg==WM_CLOSE
       INV EndDialog,hDlg,0

      ;;; kod dodany ju po wydrukowaniu ksiki
     .ELSEIF uMsg==WM_SIZE
       INV GetClientRect,hDlg,ADDR rc
       INV GetDlgItem,hDlg,ID_EDYTOR
       INV MoveWindow,eax,rc.left,rc.top,rc.right,rc.bottom,TRUE
      ;;; kod dodany ju po wydrukowaniu ksiki
       
     .ELSEIF uMsg==WM_COMMAND

       .IF wParam==ID_NOWY
         INV SetDlgItemText,hDlg,ID_EDYTOR,OFS nic
         INV SendMessage,hDlg,WM_SETTEXT,0,OFS edytor
       
       .ELSEIF wParam==ID_OTWORZ
         mov oofn.lStructSize,SIZEOF oofn

         MOM oofn.hwndOwner,hDlg
         MOM oofn.hInstance,hIns

         mov oofn.lpstrFilter,OFS ofilter

         mov oofn.lpstrCustomFilter,OFS ocustFilter
         mov oofn.nMaxCustFilter,SIZEOF ocustFilter ;256
         mov oofn.nFilterIndex,0

         mov oofn.lpstrFile,OFS ofname
         mov oofn.nMaxFile,256       ; SIZEOF ofname+bufor
         
         mov oofn.lpstrFileTitle,OFS oftitle
         mov oofn.nMaxFileTitle,SIZEOF oftitle
         
         mov oofn.lpstrInitialDir,OFS oinitDir
         
         mov oofn.lpstrTitle,OFS odlgTitle
         
         mov oofn.Flags,OFN_ENABLESIZING OR \
                        OFN_EXPLORER OR \
                        OFN_FORCESHOWHIDDEN OR \
                        OFN_PATHMUSTEXIST OR \
                        OFN_OVERWRITEPROMPT OR \
                        OFN_HIDEREADONLY OR \
                        OFN_FILEMUSTEXIST OR \
                        OFN_NODEREFERENCELINKS 
         mov oofn.nFileOffset,0
         mov oofn.lpfnHook,NULL
         mov oofn.lpTemplateName,NULL
       
         INV GetOpenFileName,OFS oofn
         .IF eax!=NULL
           INV CreateFile,OFS ofname,GENERIC_READ,NULL,NULL,\
               OPEN_EXISTING,NULL,NULL
           mov hFile,eax    
           .IF hFile!=NULL    
             INV ReadFile,hFile,OFS bufor,SIZEOF bufor,\
                 ADDR xRead,NULL
             .IF eax!=0    
               INV SetDlgItemText,hDlg,ID_EDYTOR,OFS bufor
               INV SendMessage,hDlg,WM_SETTEXT,0,OFS oftitle
             .ENDIF   
             INV CloseHandle,hFile
           .ENDIF
         .ENDIF
       
       .ELSEIF wParam==ID_ZAPISZ
         mov sofn.lStructSize,SIZEOF sofn

         MOM sofn.hwndOwner,hDlg
         MOM sofn.hInstance,hIns

         mov sofn.lpstrFilter,OFS sfilter

         mov sofn.lpstrCustomFilter,OFS scustFilter
         mov sofn.nMaxCustFilter,SIZEOF scustFilter ;256
         mov sofn.nFilterIndex,0

         mov sofn.lpstrFile,OFS sfname
         mov sofn.nMaxFile,256       ; SIZEOF sfname+bufor
         
         mov sofn.lpstrFileTitle,OFS sftitle
         mov sofn.nMaxFileTitle,SIZEOF sftitle
         
         mov sofn.lpstrInitialDir,OFS sinitDir
         
         mov sofn.lpstrTitle,OFS sdlgTitle
         
         mov sofn.Flags,OFN_ENABLESIZING OR \
                        OFN_EXPLORER OR \
                        OFN_FORCESHOWHIDDEN OR \
                        OFN_PATHMUSTEXIST OR \
                        OFN_OVERWRITEPROMPT OR \
                        OFN_HIDEREADONLY OR \
                        OFN_NODEREFERENCELINKS 
         mov sofn.nFileOffset,0
         mov sofn.lpfnHook,NULL
         mov sofn.lpTemplateName,NULL
       
         INV GetSaveFileName,OFS sofn
         .IF eax!=NULL
           INV CreateFile,OFS sfname,GENERIC_WRITE,NULL,NULL,\
               CREATE_ALWAYS,NULL,NULL
           mov hFile,eax    
           .IF hFile!=NULL    
             INV GetDlgItemText,hDlg,ID_EDYTOR,OFS bufor,SIZEOF bufor
             mov xWrite,eax
             INV WriteFile,hFile,OFS bufor,xWrite,\
                 ADDR xWrite,NULL
             .IF eax!=0    
               INV MessageBox,hDlg,OFS zapisOK,OFS edytor,MB_OK
               INV SendMessage,hDlg,WM_SETTEXT,0,OFS sftitle
             .ENDIF   
             INV CloseHandle,hFile
           .ENDIF
         .ENDIF

       .ELSEIF wParam==ID_ZAKONCZ
          INV SendMessage,hDlg,WM_CLOSE,0,0
       .ENDIF

     .ENDIF

     popad
     xor eax,eax
     ret
   DlgProc endp

   Start:                      ; pocztek programu

     INV GetModuleHandle,NULL
     mov hIns,eax
     
     INV DialogBoxParam,hIns,DLG_EDYTOR,0,ADDR DlgProc,0

     INV ExitProcess,0         ; zakoczenie programu

END Start                      ; tu zaczyna si program
