 ;
 ; ===========================================================
 ;  \Win32ASM\Src\COMIWebBrowser2_res\COMIWebBrowser2_res.asm
 ; ===========================================================
 ;                      Adam Baszczyk
 ;              "Win32ASM. Asembler w Windows"
 ;                Wydawnictwo Helion, 2004
 ; ===========================================================
 ;  Kompilacja : "r.bat", "d.bat", "nmake"
 ;  Opis       : Wykorzystanie technologii COM w Win32ASM
 ;               - osadzanie kontrolki OLE na przykadzie
 ;               kontrolki WebBrowser2 - czyli najmniejsza
 ;               przegldarka wiata! 
 ; ===========================================================

 include ..\..\makro.inc       ; doczamy definicje makr

 INCLUDEX kernel32             ; uywamy KERNEL32
 INCLUDEX user32               ; uywamy USER32
 INCLUDEX ole32                ; uywamy OLE32

 ID_DLG_MAIN   = 100
 ID_CHANGE     = 1002

.data?                         ; dane niezainicjalizowane
 hInstance dd ?
 hMainWnd dd ?
 
.data                          ; dane zainicjalizowane
; identyfikatory GUID
 XID CLSID_WebBrowser     ,'8856F961-340A-11D0-A96B-00C04FD705A2'
 XID IID_IWebBrowser2     ,'D30C1661-CDAF-11D0-8A3E-00C04FC9E26E'
 XID IID_IOleObject       ,'00000112-0000-0000-C000-000000000046'
 XID IID_IOleInPlaceObject,'00000113-0000-0000-C000-000000000046'
 XID IID_IOleInPlaceSite  ,'00000119-0000-0000-C000-000000000046'
 XID IID_IOleClientSite   ,'00000118-0000-0000-C000-000000000046'

 bJestOLE   dd FALSE 
 szPokaz    db 'Dodaj...',NULL
 szUkryj    db 'Usu... ',NULL
 
 UNI uniNULL,<>
 UNI navURL,<res://COMIWebBrowser2_res.exe/Strona.html>
 
 vnavFlags    dw VT_I4,0,0,0
              dw FALSE 
 vnavTarget   dw VT_BSTR,0,0,0
              dd NULL
 vnavPostData dw 0,0,0,0 
              dd 0
 vnavHeaders  dw VT_BSTR,0,0,0
              dd NULL

 rcOLE RECT <0,0,100,100>
 
.code                          ; segment kodu (sekcja kodu)
  cmpGUID proc uses esi edi guid1,guid2:DWORD
    mov esi,guid1
    mov edi,guid2
    mov eax,[esi]
    cmp eax,[edi]
    jne cmpGUID_ret1
    mov eax,[esi+4]
    cmp eax,[edi+4]
    jne cmpGUID_ret1
    mov eax,[esi+8]
    cmp eax,[edi+8]
    jne cmpGUID_ret1
    mov eax,[esi+12]
    cmp eax,[edi+12]
    jne cmpGUID_ret1
   cmpGUID_ret0:  
    xor eax,eax
    ret
   cmpGUID_ret1:
    xor eax,eax
    inc eax
    ret
  cmpGUID endp

;-- IOleClientSite

  mIOleClientSite_QueryInterface  proc t,riid,ppvObject:DWORD
    DEBUGGUID "mIOleClientSite::QueryInterface"
    INV cmpGUID,riid,OFS IID_IOleInPlaceSite 
    .IF eax==0
      DEBUG "req mIOleClientSite_QueryInterface:IOleInPlaceSite"
      MOP ppvObject,OFS pmIOleInPlaceSite 
      mov eax,S_OK
    .ELSE
      MOP ppvObject,NULL
      mov eax,E_NOINTERFACE
    .ENDIF
    ret
  mIOleClientSite_QueryInterface  endp

  mIOleClientSite_AddRef proc t:DWORD
    DEBUG "mIOleClientSite_AddRef"
    xor eax,eax
    inc eax
    ret
  mIOleClientSite_AddRef endp

  mIOleClientSite_Release proc t:DWORD
    DEBUG "mIOleClientSite_Release"
    xor eax,eax
    ret
  mIOleClientSite_Release endp

  mIOleClientSite_SaveObject  proc t:DWORD
    DEBUG "mIOleClientSite_SaveObject"
    mov eax,S_OK
    ret
  mIOleClientSite_SaveObject  endp

  mIOleClientSite_GetMoniker  proc t,dwAssign,\
                              dwWhichMoniker,ppmk:DWORD
    DEBUG "mIOleClientSite_GetMoniker"
    mov eax,E_NOTIMPL
    ret
  mIOleClientSite_GetMoniker  endp

  mIOleClientSite_GetContainer proc t,ppContainer:DWORD
    DEBUG "mIOleClientSite_GetContainer"
    MOP ppContainer,NULL
    mov eax,E_NOINTERFACE
    ret
  mIOleClientSite_GetContainer endp

  mIOleClientSite_ShowObject   proc t:DWORD
    DEBUG "mIOleClientSite_ShowObject"
    mov eax,S_OK
    ret
  mIOleClientSite_ShowObject   endp

  mIOleClientSite_OnShowWindow proc t,fShow:DWORD 
    DEBUG "mIOleClientSite_OnShowWindow"
    mov eax,S_OK
    ret
  mIOleClientSite_OnShowWindow endp

  mIOleClientSite_RequestNewObjectLayout proc t:DWORD
    DEBUG "mIOleClientSite_RequestNewObjectLayout"
    mov eax,E_NOTIMPL
    ret
  mIOleClientSite_RequestNewObjectLayout endp
  
;-- IOleInPlaceSite

  mIOleInPlaceSite_QueryInterface proc t,riid,ppvObject:DWORD
    DEBUGGUID "mIOleInPlaceSite::QueryInterface"
    MOP ppvObject,NULL
    mov eax,E_NOINTERFACE
    ret
  mIOleInPlaceSite_QueryInterface endp
  
  mIOleInPlaceSite_AddRef proc t:DWORD
    DEBUG "mIOleInPlaceSite_AddRef"
    xor eax,eax
    inc eax
    ret
  mIOleInPlaceSite_AddRef endp
  
  mIOleInPlaceSite_Release proc t:DWORD
    DEBUG "mIOleInPlaceSite_Release"
    xor eax,eax
    ret
  mIOleInPlaceSite_Release endp

  mIOleInPlaceSite_GetWindow proc t,phwnd:DWORD
    DEBUG "mIOleInPlaceSite_GetWindow"
    MOP phwnd,hMainWnd   
    mov eax,S_OK
    ret
  mIOleInPlaceSite_GetWindow endp

  mIOleInPlaceSite_ContextSensitiveHelp proc t,fEnterMode:DWORD
    DEBUG "mIOleInPlaceSite_ContextSensitiveHelp"
    mov eax,S_OK
    ret
  mIOleInPlaceSite_ContextSensitiveHelp endp

  mIOleInPlaceSite_CanInPlaceActivate proc t:DWORD
    DEBUG "mIOleInPlaceSite_CanInPlaceActivate"
    mov eax,S_OK
    ret
  mIOleInPlaceSite_CanInPlaceActivate endp

  mIOleInPlaceSite_OnInPlaceActivate proc t:DWORD
    DEBUG "mIOleInPlaceSite_OnInPlaceActivate"
    mov eax,S_OK
    ret
  mIOleInPlaceSite_OnInPlaceActivate endp

  mIOleInPlaceSite_OnUIActivate proc t:DWORD
    DEBUG "mIOleInPlaceSite_OnUIActivate"
    mov eax,S_OK    
    ret
  mIOleInPlaceSite_OnUIActivate endp

  mIOleInPlaceSite_GetWindowContext proc t,ppFrame,ppDoc,\
                                    lprcPosRect,lprcClipRect,\
                                    lpFrameInfo:DWORD
    DEBUG "mIOleInPlaceSite_GetWindowContext"
    MOP ppFrame,NULL
    MOP ppDoc,NULL

    INV  GetClientRect,hMainWnd,OFS rcOLE
    add  rcOLE.top,1
    add  rcOLE.left,1 
    sub  rcOLE.bottom,40 
    sub  rcOLE.right,2
    mov  eax,lprcPosRect
    MOM  [eax.RECT.left],rcOLE.left
    MOM  [eax.RECT.top],rcOLE.top
    MOM  [eax.RECT.right],rcOLE.right
    MOM  [eax.RECT.bottom],rcOLE.bottom
    mov  eax,lprcClipRect
    MOM  [eax.RECT.left],rcOLE.left
    MOM  [eax.RECT.top],rcOLE.top
    MOM  [eax.RECT.right],rcOLE.right
    MOM  [eax.RECT.bottom],rcOLE.bottom   
    
    mov  eax,lpFrameInfo
    mov [eax.OLEINPLACEFRAMEINFO.fMDIApp],FALSE
    MOM [eax.OLEINPLACEFRAMEINFO.hwndFrame],hMainWnd
    mov [eax.OLEINPLACEFRAMEINFO.haccel],NULL
    mov [eax.OLEINPLACEFRAMEINFO.cAccelEntries],0
     
    mov eax,S_OK
    ret
  mIOleInPlaceSite_GetWindowContext endp

  mIOleInPlaceSite_Scroll proc t,scrollExtant:DWORD
    DEBUG "mIOleInPlaceSite_Scroll"
    mov eax,S_OK    
    ret
  mIOleInPlaceSite_Scroll endp

  mIOleInPlaceSite_OnUIDeactivate proc t,fUndoable:DWORD
    DEBUG "mIOleInPlaceSite_OnUIDeactivate"
    mov eax,S_OK    
    ret
  mIOleInPlaceSite_OnUIDeactivate endp

  mIOleInPlaceSite_OnInPlaceDeactivate proc t:DWORD
    DEBUG "mIOleInPlaceSite_OnInPlaceDeactivate"
    mov eax,S_OK    
    ret
  mIOleInPlaceSite_OnInPlaceDeactivate endp

  mIOleInPlaceSite_DiscardUndoState proc t:DWORD
    DEBUG "mIOleInPlaceSite_DiscardUndoState"
    mov eax,S_OK    
    ret
  mIOleInPlaceSite_DiscardUndoState endp

  mIOleInPlaceSite_DeactivateAndUndo proc t:DWORD
    DEBUG "mIOleInPlaceSite_DeactivateAndUndo"
    mov eax,S_OK    
    ret
  mIOleInPlaceSite_DeactivateAndUndo endp

  mIOleInPlaceSite_OnPosRectChange proc t,lprcPosRect:DWORD
    DEBUG "mIOleInPlaceSite_OnPosRectChange"
    mov eax,S_OK    
    ret
  mIOleInPlaceSite_OnPosRectChange endp
  
.data           
;-- tablice metod wirtualnych
  mIOleClientSite label dword ; IOleClientSite
   dd OFS mIOleClientSite_QueryInterface
   dd OFS mIOleClientSite_AddRef
   dd OFS mIOleClientSite_Release
   dd OFS mIOleClientSite_SaveObject
   dd OFS mIOleClientSite_GetMoniker
   dd OFS mIOleClientSite_GetContainer
   dd OFS mIOleClientSite_ShowObject
   dd OFS mIOleClientSite_OnShowWindow
   dd OFS mIOleClientSite_RequestNewObjectLayout

  mIOleInPlaceSite label DWORD ; IOleInPlaceSite
   dd OFS mIOleInPlaceSite_QueryInterface
   dd OFS mIOleInPlaceSite_AddRef
   dd OFS mIOleInPlaceSite_Release
   dd OFS mIOleInPlaceSite_GetWindow
   dd OFS mIOleInPlaceSite_ContextSensitiveHelp
   dd OFS mIOleInPlaceSite_CanInPlaceActivate
   dd OFS mIOleInPlaceSite_OnInPlaceActivate
   dd OFS mIOleInPlaceSite_OnUIActivate
   dd OFS mIOleInPlaceSite_GetWindowContext
   dd OFS mIOleInPlaceSite_Scroll
   dd OFS mIOleInPlaceSite_OnUIDeactivate
   dd OFS mIOleInPlaceSite_OnInPlaceDeactivate
   dd OFS mIOleInPlaceSite_DiscardUndoState
   dd OFS mIOleInPlaceSite_DeactivateAndUndo
   dd OFS mIOleInPlaceSite_OnPosRectChange
        
  pmIOleClientSite   dd OFS mIOleClientSite
  pmIOleInPlaceSite  dd OFS mIOleInPlaceSite

  ppw IWebBrowser2   <0>
  ppo IOleObject     <0>

.code 
   CreateOLEControl_WebBrowser2 proc bWhat:DWORD
    .IF bWhat==TRUE

      INV CoCreateInstance,OFS CLSID_WebBrowser,NULL,\
          CLSCTX_INPROC,OFS IID_IWebBrowser2,ADDR ppw
      DEBUG "CoCreateInstance:%d",eax
      .if eax==S_OK

        COM  ppw,IWebBrowser2::QueryInterface,\
             OFS IID_IOleObject,OFS ppo

        .if eax==S_OK
          INV  OleSetContainedObject,DPTR [ppw],TRUE         
          COM  ppo,IOleObject::SetClientSite,OFS pmIOleClientSite
          COM  ppo,IOleObject::DoVerb,OLEIVERB_INPLACEACTIVATE,\
               NULL,OFS pmIOleClientSite,NULL,hMainWnd,OFS rcOLE
          .IF eax==S_OK
            DEBUG "IOleObject::DoVerb:S_OK"
          .ENDIF
                      
          COM  ppw,IWebBrowser2::Navigate,OFS navURL,\
               OFS vnavFlags,OFS vnavTarget,\
               OFS vnavPostData,OFS vnavHeaders
          .IF eax==S_OK
            DEBUG "IWebBrowser2::Navigate:S_OK"
          .ENDIF
         .endif

       .endif 
 
     .ELSE
       .IF ppw!=0 && ppo!=0
         COM  ppw,IWebBrowser2::Stop
         COM  ppo,IOleObject::Close,FALSE
         COM  ppo,IOleObject::Release
         COM  ppw,IWebBrowser2::Release
         mov  ppw,0
         mov  ppo,0
       .ENDIF
     .ENDIF
     ret
   CreateOLEControl_WebBrowser2 endp

   DlgProc proc hDlg,uMsg,wParam,lParam:DWORD
     pushad

     .IF  uMsg==WM_CLOSE
       INV CreateOLEControl_WebBrowser2,FALSE
       INV OleUninitialize       
       INV EndDialog,hDlg,0

     .ELSEIF uMsg==WM_INITDIALOG
       INV OleInitialize,NULL
       INV SetDlgItemText,hDlg,ID_CHANGE,OFS szPokaz
       MOM hMainWnd,hDlg

     .ELSEIF uMsg==WM_COMMAND
       .IF wParam==IDOK
          INV SendMessage,hDlg,WM_CLOSE,0,0

       .ELSEIF wParam==ID_CHANGE
          inc   bJestOLE      ; \ na przemian widoczna/
          and   bJestOLE,1    ; / niewidoczna

          mov   eax,bJestOLE  ; eax=0 or 1
          lea   eax,[eax*8+eax+OFS szPokaz]

          INV SetDlgItemText,hDlg,ID_CHANGE,eax

          INV CreateOLEControl_WebBrowser2,bJestOLE
        .ENDIF

     .ENDIF

     popad
     xor eax,eax
     ret
   DlgProc endp

   Start:                       ; pocztek programu

     INV GetModuleHandle,NULL
     mov hInstance,eax

     INV DialogBoxParam,hInstance,ID_DLG_MAIN,0,ADDR DlgProc,0

     INV ExitProcess,0          ; powrt z programu

END Start                       ; tu zaczyna si program
