 ;
 ; ===========================================================
 ;  \Win32ASM\Src\COMIShellLink\COMIShellLink.asm
 ; ===========================================================
 ;                      Adam Baszczyk
 ;              "Win32ASM. Asembler w Windows"
 ;                Wydawnictwo Helion, 2004
 ; ===========================================================
 ;  Kompilacja : "r.bat", "d.bat", "nmake"
 ;  Opis       : Wykorzystanie technologii COM w Win32ASM
 ;               - dodawanie i usuwanie skrtw (plikw *.lnk) 
 ; ===========================================================

 include ..\..\makro.inc       ; doczamy definicje makr

 INCLUDEX kernel32             ; uywamy KERNEL32
 INCLUDEX user32               ; uywamy USER32
 INCLUDEX ole32                ; uywamy OLE32

 ID_DLG_MAIN   = 100
 ID_CHANGE     = 1002

.data?                         ; dane niezainicjalizowane
 hInstance dd ?

.data                          ; dane zainicjalizowane
; identyfikatory GUID
  XID CLSID_ShellLink ,'00021401-0000-0000-C000-000000000046'
  XID IID_IShellLink  ,'000214EE-0000-0000-C000-000000000046'
  XID IID_IPersistFile,'0000010B-0000-0000-C000-000000000046'

 bJestLink  dd FALSE
 szPokaz    db 'Dodaj...',NULL
 szUkryj    db 'Usu... ',NULL

 szMyLink   db 'COMIShellLink',NULL
 szMyPath   db 'c:\COMIShellLink.lnk',NULL

.code                          ; segment kodu (sekcja kodu)
   CreateShortCut proc bWhat,szFile,szLink,szPath:DWORD
    LOCAL psl:IShellLink
    LOCAL ppf:IPersistFile
    LOCAL wsz[256]: WORD

     .IF bWhat==TRUE
       INV CoInitialize,NULL
       INV CoCreateInstance,OFS CLSID_ShellLink,NULL,\
           CLSCTX_INPROC_SERVER,OFS IID_IShellLink,ADDR psl

       .if eax==S_OK
          COM  psl,IShellLink::SetPath,szFile
          COM  psl,IShellLink::SetDescription,szLink
          COM  psl,IShellLink::QueryInterface,\
               OFS IID_IPersistFile,ADDR ppf
          .if eax==S_OK
            INV MultiByteToWideChar,CP_ACP,0,szPath,-1,ADR wsz,SIZEOF wsz
            COM ppf,IPersistFile::Save,ADDR wsz,TRUE
            COM ppf,IPersistFile::Release
          .endif
          COM psl,IShellLink::Release
       .endif
       INV CoUninitialize
     .ELSE
       INV DeleteFile,szPath
     .ENDIF
     ret
   CreateShortCut endp

   DlgProc proc hDlg,uMsg,wParam,lParam:DWORD
    LOCAL pszAppFileName[256]:BYTE
     pushad

     .IF  uMsg==WM_CLOSE
       INV EndDialog,hDlg,0

     .ELSEIF uMsg==WM_INITDIALOG
       INV SetDlgItemText,hDlg,ID_CHANGE,OFS szPokaz

     .ELSEIF uMsg==WM_COMMAND

       .IF wParam==IDOK
          INV SendMessage,hDlg,WM_CLOSE,0,0

       .ELSEIF wParam==ID_CHANGE
          inc   bJestLink      ; \ na przemian widoczny/
          and   bJestLink,1    ; / niewidoczny

          mov   eax,bJestLink  ; eax=0 lub 1
          lea   eax,[eax*8+eax+OFS szPokaz]

          INV SetDlgItemText,hDlg,ID_CHANGE,eax

          INV GetModuleFileName,NULL,ADR pszAppFileName,\
              SIZEOF pszAppFileName

          INV CreateShortCut,bJestLink,ADR pszAppFileName,\
              OFS szMyLink,OFS szMyPath
        .ENDIF

     .ENDIF

     popad
     xor eax,eax
     ret
   DlgProc endp

   Start:                      ; pocztek programu

     INV GetModuleHandle,NULL
     mov hInstance,eax

     INV DialogBoxParam,hInstance,ID_DLG_MAIN,0,ADDR DlgProc,0

     INV ExitProcess,0         ; powrt z programu
     
END Start                      ; tu zaczyna si program
