#
# =======================================================
#                      Adam Baszczyk
#              "Win32ASM. Asembler w Windows"
#                Wydawnictwo Helion, 2004
# =======================================================
#
# "makefile.mak"
#
# Plik wsplny dla wszystkich projektw.
# Zawiera definicje zmiennych okrelajcych pooenie
# MASM32 na dysku (zmienna MASMDIR), a take powoduje,
# e kompilacja przeprowadzana jest automatycznie
#
# Skrypt jest do uniwersalny i pozwala generowa
# dwie wersje programu: RELEASE i DEBUG. Wersja
# RELEASE ma tak nazw pliku wykonywalnego jak
# nazwa projektu, natomiast w przypadku wersji DEBUG,
# do nazwy projektu dodawany jest przyrostek "d".

#########################################################
# Poniej naley poda pen ciek do Masm32
#########################################################

MASMDIR=c:\Masm32

#########################################################
#  Poniej nie trzeba nic zmienia.
#  Na wejciu potrzebne s wartoci zmiennych:
#   MASMDIR  = cieka do MASM32
#########################################################

# cieka do plikw bibliotek (*.lib)
MASMLIBDIR=$(MASMDIR)\LIB

# cieka do plikw nagwkowych (*.inc)
MASMINCDIR=$(MASMDIR)\INCLUDE

# cieka do plikw wykonywalnych (ml, link, rc)
MASMBINDIR=$(MASMDIR)\BIN

# Wykorzystywane programy wykonywalne:
LINK=$(MASMBINDIR)\link.exe
ML=$(MASMBINDIR)\ml.exe
RC=$(MASMBINDIR)\rc.exe

#########################################################
#  Poniej nie trzeba nic zmienia.
#  Na wejciu potrzebne s wartoci zmiennych:
#   PRO  = nazwa pliku gwnego .ASM
#   DLL  = okrela czy budowana jest biblioteka DLL
#          jeli DLL==NIE, tworzony jest plik EXE
#   RES  = okrela czy doczane s zasoby
#          (ang. resources)
#   DEB  = okrela czy tworzona jest wersja DEBUG
#          jeli DEB==NIE, tworzona jest wersja RELEASE
#   VERB = jeeli VERB==TAK, wywietlane bdzie wicej
#          informacji o procesie budowania (ang. verbose)
#########################################################

# Ustalamy wartoci zmiennych w zalenoci od tego,
# czy projekt jest w wersji DEBUG czy RELEASE.
!IF "$(DEB)"=="TAK"
MSG=Wersja DEBUG
DEBPAR1=/Zd /Zi /DDEB=1
DEBPAR2=/DEBUG
PROOUT=$(PRO)d
!ELSE
MSG=Wersja RELEASE
DEBPAR1=/DDEB=0
DEBPAR2=
PROOUT=$(PRO)
!ENDIF

# Ustalamy wartoci zmiennych w zalenoci od tego,
# czy projekt jest plikiem EXE czy DLL.
!IF "$(DLL)"=="TAK"
MSG=$(MSG), plik DLL
PRODLL=/DLL /DEF:$(PRO).def
PROOUT=$(PROOUT).dll
!ELSE
MSG=$(MSG), plik EXE
PRODLL=
PROOUT=$(PROOUT).exe
!ENDIF

# Ustalamy wartoci zmiennych w zalenoci od tego,
# czy projekt zawiera zasoby.
!IF "$(RES)"=="TAK"
MSG=$(MSG) z zasobami
PRORES=$(PRO).RES
!ELSE
MSG=$(MSG) bez zasobw
PRORES=
!ENDIF

# Ustalamy czy maj by wywietlane dodatkowe informacje
# domylnie wywietlana jest jak najmniejsza liczba
# informacji podczas budowania pliku wynikowego.
!IF "$(VERB)"=="TAK"
MLVERB=
LINKVERB=/verbose
RCVERB=/v
!ELSE
MLVERB=/nologo
LINKVERB=/nologo
RCVERB=
!ENDIF

!MESSAGE **********************************************
!MESSAGE  Info:
!MESSAGE   cieka do MASM: $(MASMDIR)
!MESSAGE  Tworz projekt "$(PRO)".
!MESSAGE   $(MSG).
!MESSAGE **********************************************

# Waciwy proces kompilacji i linkowania.

PROASM=$(PRO).asm
PROOBJ=$(PRO).obj

$(PROOUT): $(PROOBJ) $(PRORES)
  if exist $(PROOUT) del $(PROOUT)
  $(LINK) $(LINKVERB)            \
          /subsystem:WINDOWS     \
          /libpath:$(MASMLIBDIR) \
          /OUT:$(PROOUT)         \
          $(PRODLL)              \
          $(DEBPAR2)             \
          $(PROOBJ)              \
          $(PRORES)
  if exist $(PROOBJ) del $(PROOBJ)

!IF "$(RES)"=="TAK"
  if exist $(PRORES) del $(PRORES)
!ENDIF

$(PROOBJ): $(PROASM)
  $(ML) $(MLVERB)       \
        /c              \
        /coff           \
        /Cp             \
        /I$(MASMINCDIR) \
        $(DEBPAR1)      \
        $(PROASM)

!IF "$(RES)"=="TAK"
$(PRO).res: $(PRO).rc
  $(RC) $(RCVERB) /d__LCC__ $(PRO).rc
!ENDIF

