 ;
 ; ===========================================================
 ;  \win32asm\SRC\IntUp\IntUp.asm
 ; ===========================================================
 ;                      Adam Baszczyk
 ;              "Win32ASM. Asembler w Windows"
 ;                Wydawnictwo Helion, 2004
 ; ===========================================================
 ;  Kompilacja : "r.bat", "d.bat", "nmake"
 ;  Opis       : Program demonstruje jak pobra plik
 ;               ze wskazanego adresu w Internecie
 ; ===========================================================

 include ..\..\makro.inc       ; doczamy definicje makr

 INCLUDEX kernel32             ; uywamy KERNEL32.DLL
 INCLUDEX user32               ; uywamy USER32.DLL
 INCLUDEX gdi32                ; uywamy GDI32.DLL
 INCLUDEX wininet              ; uywamy WININET.DLL

 ID_DLG_MAIN   = 100
 ID_EDT_INTUP  = 1000
 ID_BTN_INTUP  = 1001
 ID_BTN_KONIEC = 1002
 ID_FRM_1      = 1003

.data?                         ; dane niezainicjalizowane
 hIns      dd ?
 hEdt      dd ?
 hNet      dd ?
 hURL      dd ?
 hBrush    dd ?

.data                          ; dane zainicjalizowane
 TxCRLF   db CR,LF,NULL
 TxStart  db '-> Start',NULL
 TxKoniec db '-> Koniec',NULL
 TxIO     db '-> Wywouj funkcj InternetOpen',NULL
 TxIOU    db '-> Wywouj funkcj InternetOpenUrl',NULL
 TxIRF    db '-> Wywouj funkcj InternetReadFile',NULL
 TxICH    db '-> Wywouj funkcj InternetCloseHandle',NULL
 TxBlad1  db 'BD: Nie mog si poczy',NULL
 TxBlad2  db 'BD: Nie mog otworzy strony',NULL
 TxBlad3  db 'BD: Nie mog przeczyta pliku',NULL
 TxMIE    db 'Microsoft Internet Explorer',NULL
 TxUPDURL db 'http://www.mykakee.com/xiazki/Win32ASM/IntUp.txt',NULL


.code                          ; segment kodu (sekcja kodu)

   Dopisz proc Px:DWORD
     LOCAL Bufor[4096]:BYTE
     INV lstrcpy,ADDR Bufor,Px
     INV lstrcat,ADDR Bufor,OFS TxCRLF
     INV SendMessage,hEdt,EM_REPLACESEL,FALSE,ADDR Bufor

     ret
   Dopisz endp

   DlgProc proc hDlg,uMsg,wParam,lParam:DWORD
    LOCAL Bufor[2048]:BYTE
    LOCAL Dlug,Tlo:DWORD
     
     pushad

     .IF  uMsg==WM_INITDIALOG
       INV   GetDlgItem,hDlg,ID_EDT_INTUP
       mov   hEdt,eax

       INV   CreateSolidBrush,RGB(0FFh,0FFh,0FFh)
       mov   hBrush,eax

     .ELSEIF  uMsg==WM_CLOSE
       INV   DeleteObject,hBrush
       INV   EndDialog,hDlg,0

     .ELSEIF uMsg==WM_CTLCOLORSTATIC
       mov   eax,lParam
       .IF eax==hEdt
         popad
         mov   eax,hBrush
         ret
       .ENDIF

     .ELSEIF uMsg==WM_COMMAND

       .IF wParam==ID_BTN_INTUP
         INV   Dopisz,OFS TxStart

         INV   Dopisz,OFS TxIO
         INV   InternetOpen,OFS TxMIE,\
               INTERNET_OPEN_TYPE_PRECONFIG,NULL,NULL,NULL

         .IF eax==NULL
           INV   Dopisz,OFS TxBlad1
           
         .ELSE
           mov   hNet,eax
           INV   Dopisz,OFS TxIOU
         
           INV   InternetOpenUrl,hNet,OFS TxUPDURL,NULL,\
                 NULL,NULL,NULL
           .IF eax==NULL
             INV   Dopisz,OFS TxBlad2
           
           .ELSE
             mov   hURL,eax
             INV   Dopisz,OFS TxIRF
            CzytajDalej: 
             INV   InternetReadFile,hURL,ADDR Bufor,\
                   SIZEOF Bufor,ADDR Dlug
             .IF eax==TRUE
               mov   eax,Dlug
               mov   BPTR [Bufor+eax],0
               INV   Dopisz,ADDR Bufor
               .IF   Dlug!=0
                  jmp CzytajDalej
               .ENDIF 
             .ELSE
               INV   Dopisz,OFS TxBlad3
             .ENDIF

             INV Dopisz,OFS TxICH
             INV InternetCloseHandle,hURL      
           .ENDIF

           INV Dopisz,OFS TxICH

           INV InternetCloseHandle,hNet
         .ENDIF

         INV Dopisz,OFS TxKoniec

       .ELSEIF wParam==ID_BTN_KONIEC
           INV SendMessage,hDlg, WM_CLOSE,0,0

       .ENDIF

     .ENDIF

     popad
     xor    eax,eax    
     ret     
   DlgProc endp

   Start:                      ; pocztek programu
     INV   GetModuleHandle,NULL
     mov   hIns,eax

     INV   DialogBoxParam,hIns,ID_DLG_MAIN,0,ADDR DlgProc,0

     INV   ExitProcess,0       ; powrt z programu

END Start                      ; tu zaczyna si program
