 ;
 ; ===========================================================
 ;  \Win32ASM\Src\COMITaskbarList\COMITaskbarList.asm
 ; ===========================================================
 ;                      Adam Baszczyk
 ;              "Win32ASM. Asembler w Windows"
 ;                Wydawnictwo Helion, 2004
 ; ===========================================================
 ;  Kompilacja : "r.bat", "d.bat", "nmake"
 ;  Opis       : Wykorzystanie technologii COM w Win32ASM
 ;               - dodawanie i usuwanie okna z paska zada
 ; ===========================================================

 include ..\..\makro.inc       ; doczamy definicje makr

 INCLUDEX kernel32             ; uywamy KERNEL32
 INCLUDEX user32               ; uywamy USER32
 INCLUDEX ole32                ; uywamy OLE32

 ID_DLG_MAIN   = 100
 ID_CHANGE     = 1002

  ; tablica metod udostepnianych przez interfejs ITaskbarList
 ITaskbarListVtbl STRUC
    ; interfejs IUnknown
   QueryInterface         dd ?
   AddRef                 dd ?
   Release                dd ?
    ; interfejs ITaskbarList
   HrInit                 dd ?
   AddTab                 dd ?
   DeleteTab              dd ?
   ActivateTab            dd ?
   SetActiveAlt           dd ?
 ITaskbarListVtbl ENDS

  ; interfejs; w praktyce jest to 32-bitowa zmienna
  ; przechowujca adres do tablicy metod interfejsu
  ; - w tym przypadku: ITaskbarListVtbl
 ITaskbarList STRUC
   lpVtbl dd ?
 ITaskbarList ENDS

 COM MACRO ppv,metoda
     mov  eax,ppv.lpVtbl   ; adres do interfejsu
     mov  eax,[eax]        ; wskanik na tablice metod
     mov  eax,[eax.metoda] ; adres do metody
     push ppv              ; wskanik obiektu (this)
     call eax              ; wywoujemy metod
 ENDM

.data?                         ; dane niezainicjalizowane
 hInstance dd ?

.data                          ; dane zainicjalizowane
; identyfikatory GUID
; CLSID_TaskbarList '56FDF344-FD6D-11D0-958A-006097C9A090'
  CLSID_TaskbarList \
  GUID <56FDF344h,0FD6Dh,11D0h,<95h,8Ah,0,60h,97h,0C9h,0A0h,90h>>

; IID_ITaskbarList  '56FDF342-FD6D-11D0-958A-006097C9A090'
  IID_ITaskbarList  \
  GUID <56FDF342h,0FD6Dh,11D0h,<95h,8Ah,0,60h,97h,0C9h,0A0h,90h>>

 bWidoczny  dd FALSE
 szPokaz    db 'Poka...',NULL
 szUkryj    db 'Ukryj...',NULL

.code                          ; segment kodu (sekcja kodu)
   ShowOnTaskbar proc hWnd,bVisible:DWORD
    LOCAL  ShellTaskbar:ITaskbarList

     INV CoInitialize,NULL

     INV CoCreateInstance,OFS CLSID_TaskbarList,NULL,\
         CLSCTX_INPROC_SERVER,OFS IID_ITaskbarList,\
         ADDR ShellTaskbar

     .IF eax==S_OK

        COM ShellTaskbar,ITaskbarListVtbl.HrInit
        .IF eax==NOERROR

           .IF bVisible==TRUE
               push hWnd
               COM ShellTaskbar,ITaskbarListVtbl.AddTab

               push hWnd
               COM ShellTaskbar,ITaskbarListVtbl.ActivateTab

           .else
               push hWnd
               COM ShellTaskbar,ITaskbarListVtbl.DeleteTab
           .ENDIF

        .ENDIF

        COM ShellTaskbar,ITaskbarListVtbl.Release
      .ENDIF

      INV CoUninitialize

      ret
   ShowOnTaskbar  endp

   DlgProc proc hDlg,uMsg,wParam,lParam:DWORD
     pushad

     .IF  uMsg==WM_CLOSE
       INV EndDialog,hDlg,0

     .ELSEIF uMsg==WM_INITDIALOG
       INV SetDlgItemText,hDlg,ID_CHANGE,OFS szPokaz

     .ELSEIF uMsg==WM_COMMAND

       .IF wParam==IDOK
          INV SendMessage,hDlg,WM_CLOSE,0,0

       .ELSEIF wParam==ID_CHANGE
          inc   bWidoczny      ; \ na przemian widoczny/
          and   bWidoczny,1    ; / niewidoczny

          mov   eax,bWidoczny  ; eax=0 or 1
          lea   eax,[eax*8+eax+OFS szPokaz]

          INV SetDlgItemText,hDlg,ID_CHANGE,eax

          INV ShowOnTaskbar,hDlg,bWidoczny
        .ENDIF

     .ENDIF

     popad
     xor eax,eax
     ret
   DlgProc endp

   Start:                      ; pocztek programu

     INV GetModuleHandle,NULL
     mov hInstance,eax

     INV DialogBoxParam,hInstance,ID_DLG_MAIN,0,ADDR DlgProc,0

     INV ExitProcess,0         ; powrt z programu

END Start                      ; tu zaczyna si program
