 ;
 ; ===========================================================
 ;  \Win32ASM\Src\AppBar\AppBar.asm
 ; ===========================================================
 ;                      Adam Baszczyk
 ;              "Win32ASM. Asembler w Windows"
 ;                Wydawnictwo Helion, 2004
 ; ===========================================================
 ;  Kompilacja : "r.bat", "d.bat", "nmake"
 ;  Opis       : Okno typu AppBar
 ; ===========================================================

 include ..\..\makro.inc

 INCLUDEX kernel32
 INCLUDEX user32
 INCLUDEX shell32

 WM_APPBAR_MSG = 7000h

.data?                         ; sekcja danych bez wart. pocz.
 hInst     dd ?
 scrH      dd ?
 wc        WNDCLASSEX <>
 msg       MSG       <>
.data 
 wcClass   db 'kakeeWndClass',NULL
 tyt       db 'Okno typu AppBar',NULL

.code                          ; sekcja kodu

  mainWndProc proc hWnd,uMsg,wPar,lPar:DWORD
    LOCAL pabd:APPBARDATA
      .if uMsg==WM_CREATE
        INV  GetSystemMetrics,SM_CYSCREEN
        mov  scrH,eax

        mov  pabd.cbSize,SIZEOF pabd
        M2M  [pabd.hwnd],hWnd
        mov  pabd.uCallbackMessage,WM_APPBAR_MSG
        INV  SHAppBarMessage,ABM_NEW,ADDR pabd
 
        mov  pabd.cbSize,SIZEOF pabd
        M2M  [pabd.hwnd],hWnd
        mov  pabd.uEdge,ABE_LEFT
        mov  pabd.rc.left,0
        mov  pabd.rc.top,0
        mov  pabd.rc.right,40
        M2M  pabd.rc.bottom,scrH
        INV  SHAppBarMessage,ABM_QUERYPOS,ADDR pabd
         
        mov  pabd.cbSize,SIZEOF pabd
        M2M  [pabd.hwnd],hWnd
        mov  pabd.uEdge,ABE_LEFT
        INV  SHAppBarMessage,ABM_SETPOS,ADDR pabd
        
        mov  eax,pabd.rc.left
        add  eax,40
        mov  pabd.rc.right,eax
        INV  MoveWindow,hWnd,pabd.rc.left,pabd.rc.top,\
             eax,pabd.rc.bottom,TRUE

        jmp  ret0

      .elseif  uMsg==WM_APPBAR_MSG
        .if wPar==ABN_POSCHANGED
          mov  pabd.cbSize,SIZEOF pabd
          M2M  [pabd.hwnd],hWnd
          mov  pabd.uEdge,ABE_LEFT
          mov  pabd.rc.left,0
          mov  pabd.rc.top,0
          mov  pabd.rc.right,40
          M2M  pabd.rc.bottom,scrH
          INV  SHAppBarMessage,ABM_QUERYPOS,ADDR pabd
           
          mov  pabd.cbSize,SIZEOF pabd
          M2M  [pabd.hwnd],hWnd
          mov  pabd.uEdge,ABE_LEFT
          INV  SHAppBarMessage,ABM_SETPOS,ADDR pabd
          
          mov  eax,pabd.rc.left
          add  eax,40
          mov  pabd.rc.right,eax
          INV  MoveWindow,hWnd,pabd.rc.left,pabd.rc.top,\
               eax,pabd.rc.bottom,TRUE
        .endif
        jmp  ret0
       
      .elseif  uMsg==WM_ACTIVATE
        mov  pabd.cbSize,SIZEOF pabd
        M2M  [pabd.hwnd],hWnd
        INV  SHAppBarMessage,ABM_ACTIVATE,ADDR pabd
        jmp  ret0
    
      .elseif  uMsg==WM_WINDOWPOSCHANGED
        mov  pabd.cbSize,SIZEOF pabd
        M2M  [pabd.hwnd],hWnd
        INV  SHAppBarMessage,ABM_WINDOWPOSCHANGED,ADDR pabd
        jmp  ret0
      
      .elseif (uMsg==WM_LBUTTONDOWN) || (uMsg==WM_RBUTTONDOWN)
        INV  SendMessage,hWnd,WM_CLOSE,0,0
        jmp  ret0
        
      .elseif uMsg==WM_DESTROY
        mov  pabd.cbSize,SIZEOF pabd
        M2M  [pabd.hwnd],hWnd
        INV  SHAppBarMessage,ABM_REMOVE,ADDR pabd
       
        INV  PostQuitMessage,NULL
        jmp  ret0

      .endif
      INV DefWindowProc,hWnd,uMsg,wPar,lPar
      ret

    ret0:
      xor  eax,eax
      ret

  mainWndProc endp

  Start:                       ; pocztek programu
    INV  GetModuleHandle,NULL  ; pobieramy uchwyt moduu
    mov  hInst,eax             ; i zapisujemy go do zmiennej

    xor  eax,eax               ; struktura WNDCLASSEX
    mov  wc.cbSize,SIZEOF wc
    mov  wc.cbClsExtra,eax
    mov  wc.cbWndExtra,eax
    mov  wc.hbrBackground,1+COLOR_BTNFACE
    mov  wc.hIcon,eax
    mov  wc.lpfnWndProc,OFS mainWndProc
    mov  wc.lpszClassName,OFS wcClass
    mov  wc.lpszMenuName,NULL
    mov  wc.style,CS_HREDRAW or CS_VREDRAW
    INV  LoadCursor,NULL,IDC_ARROW
    mov  wc.hCursor,eax
    MOM  wc.hInstance,hInst
    INV  RegisterClassEx,OFS wc

    INV  CreateWindowEx,WS_EX_TOOLWINDOW,OFS wcClass,OFS tyt,\
                        WS_POPUPWINDOW or WS_VISIBLE,\
                        0,0,200,150,NULL,NULL,hInst,NULL
    
 petlaKom:
    xor  eax,eax
    INV  GetMessage,OFS msg,eax,eax,eax
    or   eax,eax
    je   Koniec
    INV  TranslateMessage,OFS msg
    INV  DispatchMessage,OFS msg
    jmp  petlaKom

  Koniec:
    INV  ExitProcess,msg.wParam

END Start                      ; tu zaczyna si program

