.386
.model	flat, stdcall
option	casemap :none

include		bones.inc

.code
start:
	invoke	GetModuleHandle, NULL
	mov	hInstance, eax
	invoke	InitCommonControls
	invoke	DialogBoxParam, hInstance, IDD_MAIN, 0, offset DlgProc, 0
	invoke	ExitProcess, eax
	
KeyBoardProc proc nCode:DWORD, wParam:DWORD, lParam:DWORD
	LOCAL	lpKeyState[256]	:BYTE
    LOCAL   lpClassName[64]	:BYTE
	LOCAL	lpCharBuf[32]	:BYTE
    LOCAL   lpDateBuf[12]	:BYTE
    LOCAL   lpTimeBuf[12]	:BYTE
    LOCAL   lpLocalTime	:SYSTEMTIME
	;----------------------------

	lea	edi, [lpKeyState]
	push	256/4
	pop	ecx
	xor	eax, eax
	rep	stosd

	mov	eax, wParam
	cmp	eax, WM_KEYUP
	je	next_hook 

	cmp	eax, WM_SYSKEYUP
	je	next_hook 

no_window_change:
	mov	esi, [lParam]
	lodsd
	cmp	al, VK_LSHIFT
	je	next_hook
	cmp	al, VK_RSHIFT
	je	next_hook
	cmp	al, VK_CAPITAL
	je	next_hook
	cmp	al, VK_ESCAPE
	je	get_name_of_key
	cmp	al, VK_BACK
	je	get_name_of_key
	cmp	al, VK_TAB
	je	get_name_of_key
	;------------------
	lea	edi, [lpCharBuf]
	push	32/4
	pop	ecx
	xor	eax, eax
	rep	stosd
	;----------

	lea	ebx, [lpKeyState]
	push	ebx
	call	GetKeyboardState 

	invoke	GetKeyState, VK_LSHIFT
	xchg	esi, eax

	invoke	GetKeyState, VK_RSHIFT
	or	eax, esi

	mov	byte ptr [ebx + 16], al

	invoke	GetKeyState, VK_CAPITAL
	mov	byte ptr [ebx + 20], al

	mov	esi, [lParam]
	lea	edi, [lpCharBuf]
	push	00h
	push	edi
	push	ebx
	lodsd
	xchg	eax, edx
	lodsd
	push	eax
	push	edx
	call	ToAscii
	test	eax, eax
	jnz	test_carriage_return 

get_name_of_key:
	mov	esi, [lParam]
	lodsd
	lodsd
	shl	eax, 16
	xchg	eax, ecx
	lodsd
	shl	eax, 24
	or	ecx, eax

	push	32
	lea	edi, [lpCharBuf]
	push	edi
	push	ecx
	call	GetKeyNameTextA 

	jmp	write_to_screen

test_carriage_return:

	cmp	byte ptr [edi], 0dh
	jne	write_to_screen

	mov	byte ptr [edi + 1], 0ah
write_to_screen:
	invoke lstrcat, addr szLog, edi
	invoke	SetDlgItemText, hWnd, 1003, addr szLog

next_hook:
	invoke	CallNextHookEx, hHook, nCode, wParam, lParam
	ret

KeyBoardProc endp

DlgProc proc hWin:DWORD,uMsg:DWORD,wParam:DWORD,lParam:DWORD
	mov	eax,uMsg
	
	.if	eax == WM_INITDIALOG
		push hWin
		pop  hWnd
	.elseif eax == WM_COMMAND
		mov	eax,wParam
		.if	eax == 1001
			invoke GetModuleHandle, NULL
			invoke 	SetWindowsHookExA, WH_KEYBOARD_LL, addr KeyBoardProc, eax, 0
			mov	[hHook], eax
		.elseif eax == 1002
			invoke	UnhookWindowsHookEx, hHook
		.endif
	.elseif	eax == WM_CLOSE
		invoke	UnhookWindowsHookEx, hHook
		invoke	EndDialog, hWin, 0
	.endif

	xor	eax,eax
	ret
DlgProc endp

end start