/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.app;

import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.ActionBarDrawerToggle;
import android.support.v7.app.ActionBar;
import android.support.v7.app.ActionBarActivity;
import android.support.v7.app.ActionBarActivityDelegateBase;
import android.support.v7.app.ActionBarActivityDelegateHC;
import android.support.v7.app.ActionBarDrawerToggle;
import android.support.v7.appcompat.R;
import android.support.v7.internal.app.WindowCallback;
import android.support.v7.internal.view.SupportMenuInflater;
import android.support.v7.view.ActionMode;
import android.support.v7.widget.Toolbar;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;

abstract class ActionBarActivityDelegate {
    static final String METADATA_UI_OPTIONS = "android.support.UI_OPTIONS";
    private static final String TAG = "ActionBarActivityDelegate";
    final ActionBarActivity mActivity;
    private ActionBar mActionBar;
    private MenuInflater mMenuInflater;
    boolean mHasActionBar;
    boolean mOverlayActionBar;
    boolean mOverlayActionMode;
    boolean mIsFloating;
    final WindowCallback mDefaultWindowCallback = new WindowCallback(){

        @Override
        public boolean onMenuItemSelected(int featureId, MenuItem menuItem) {
            return ActionBarActivityDelegate.this.mActivity.onMenuItemSelected(featureId, menuItem);
        }

        @Override
        public boolean onCreatePanelMenu(int featureId, Menu menu) {
            return ActionBarActivityDelegate.this.mActivity.superOnCreatePanelMenu(featureId, menu);
        }

        @Override
        public boolean onPreparePanel(int featureId, View menuView, Menu menu) {
            return ActionBarActivityDelegate.this.mActivity.superOnPreparePanel(featureId, menuView, menu);
        }

        @Override
        public void onPanelClosed(int featureId, Menu menu) {
            ActionBarActivityDelegate.this.mActivity.onPanelClosed(featureId, menu);
        }

        @Override
        public boolean onMenuOpened(int featureId, Menu menu) {
            return ActionBarActivityDelegate.this.mActivity.onMenuOpened(featureId, menu);
        }

        @Override
        public ActionMode startActionMode(ActionMode.Callback callback) {
            return ActionBarActivityDelegate.this.startSupportActionModeFromWindow(callback);
        }

        @Override
        public View onCreatePanelView(int featureId) {
            return null;
        }
    };
    private WindowCallback mWindowCallback;
    private boolean mIsDestroyed;

    static ActionBarActivityDelegate createDelegate(ActionBarActivity activity) {
        if (Build.VERSION.SDK_INT >= 11) {
            return new ActionBarActivityDelegateHC(activity);
        }
        return new ActionBarActivityDelegateBase(activity);
    }

    ActionBarActivityDelegate(ActionBarActivity activity) {
        this.mActivity = activity;
        this.mWindowCallback = this.mDefaultWindowCallback;
    }

    abstract ActionBar createSupportActionBar();

    final ActionBar getSupportActionBar() {
        if (this.mHasActionBar && this.mActionBar == null) {
            this.mActionBar = this.createSupportActionBar();
        }
        return this.mActionBar;
    }

    protected final void setSupportActionBar(ActionBar actionBar) {
        this.mActionBar = actionBar;
    }

    abstract void setSupportActionBar(Toolbar var1);

    MenuInflater getMenuInflater() {
        if (this.mMenuInflater == null) {
            this.mMenuInflater = new SupportMenuInflater(this.getActionBarThemedContext());
        }
        return this.mMenuInflater;
    }

    void onCreate(Bundle savedInstanceState) {
        TypedArray a = this.mActivity.obtainStyledAttributes(R.styleable.Theme);
        if (!a.hasValue(R.styleable.Theme_windowActionBar)) {
            a.recycle();
            throw new IllegalStateException("You need to use a Theme.AppCompat theme (or descendant) with this activity.");
        }
        this.mHasActionBar = a.getBoolean(R.styleable.Theme_windowActionBar, false);
        this.mOverlayActionBar = a.getBoolean(R.styleable.Theme_windowActionBarOverlay, false);
        this.mOverlayActionMode = a.getBoolean(R.styleable.Theme_windowActionModeOverlay, false);
        this.mIsFloating = a.getBoolean(R.styleable.Theme_android_windowIsFloating, false);
        a.recycle();
    }

    abstract void onConfigurationChanged(Configuration var1);

    abstract void onStop();

    abstract void onPostResume();

    abstract void setContentView(View var1);

    abstract void setContentView(int var1);

    abstract void setContentView(View var1, ViewGroup.LayoutParams var2);

    abstract void addContentView(View var1, ViewGroup.LayoutParams var2);

    abstract void onTitleChanged(CharSequence var1);

    abstract void supportInvalidateOptionsMenu();

    abstract boolean supportRequestWindowFeature(int var1);

    abstract View onCreatePanelView(int var1);

    abstract boolean onPreparePanel(int var1, View var2, Menu var3);

    abstract void onPanelClosed(int var1, Menu var2);

    abstract boolean onMenuOpened(int var1, Menu var2);

    boolean onPrepareOptionsPanel(View view, Menu menu) {
        if (Build.VERSION.SDK_INT < 16) {
            return this.mActivity.onPrepareOptionsMenu(menu);
        }
        return this.mActivity.superOnPrepareOptionsPanel(view, menu);
    }

    abstract boolean onCreatePanelMenu(int var1, Menu var2);

    abstract boolean onBackPressed();

    abstract ActionMode startSupportActionMode(ActionMode.Callback var1);

    abstract void setSupportProgressBarVisibility(boolean var1);

    abstract void setSupportProgressBarIndeterminateVisibility(boolean var1);

    abstract void setSupportProgressBarIndeterminate(boolean var1);

    abstract void setSupportProgress(int var1);

    boolean onKeyDown(int keyCode, KeyEvent event) {
        return false;
    }

    abstract boolean onKeyShortcut(int var1, KeyEvent var2);

    final ActionBarDrawerToggle.Delegate getDrawerToggleDelegate() {
        return new ActionBarDrawableToggleImpl();
    }

    final ActionBarDrawerToggle.Delegate getV7DrawerToggleDelegate() {
        return new ActionBarDrawableToggleImpl();
    }

    abstract int getHomeAsUpIndicatorAttrId();

    abstract void onContentChanged();

    final String getUiOptionsFromMetadata() {
        try {
            PackageManager pm = this.mActivity.getPackageManager();
            ActivityInfo info = pm.getActivityInfo(this.mActivity.getComponentName(), 128);
            String uiOptions = null;
            if (info.metaData != null) {
                uiOptions = info.metaData.getString(METADATA_UI_OPTIONS);
            }
            return uiOptions;
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e((String)TAG, (String)("getUiOptionsFromMetadata: Activity '" + this.mActivity.getClass().getSimpleName() + "' not in manifest"));
            return null;
        }
    }

    protected final Context getActionBarThemedContext() {
        Object context = null;
        ActionBar ab = this.getSupportActionBar();
        if (ab != null) {
            context = ab.getThemedContext();
        }
        if (context == null) {
            context = this.mActivity;
        }
        return context;
    }

    abstract View createView(String var1, @NonNull AttributeSet var2);

    abstract ActionMode startSupportActionModeFromWindow(ActionMode.Callback var1);

    final void setWindowCallback(WindowCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback can not be null");
        }
        this.mWindowCallback = callback;
    }

    final WindowCallback getWindowCallback() {
        return this.mWindowCallback;
    }

    final void destroy() {
        this.mIsDestroyed = true;
    }

    final boolean isDestroyed() {
        return this.mIsDestroyed;
    }

    private class ActionBarDrawableToggleImpl
    implements ActionBarDrawerToggle.Delegate,
    ActionBarDrawerToggle.Delegate {
        private ActionBarDrawableToggleImpl() {
        }

        @Override
        public Drawable getThemeUpIndicator() {
            TypedArray a = ActionBarActivityDelegate.this.getActionBarThemedContext().obtainStyledAttributes(new int[]{ActionBarActivityDelegate.this.getHomeAsUpIndicatorAttrId()});
            Drawable result = a.getDrawable(0);
            a.recycle();
            return result;
        }

        @Override
        public Context getActionBarThemedContext() {
            return ActionBarActivityDelegate.this.getActionBarThemedContext();
        }

        @Override
        public void setActionBarUpIndicator(Drawable upDrawable, int contentDescRes) {
            ActionBar ab = ActionBarActivityDelegate.this.getSupportActionBar();
            if (ab != null) {
                ab.setHomeAsUpIndicator(upDrawable);
                ab.setHomeActionContentDescription(contentDescRes);
            }
        }

        @Override
        public void setActionBarDescription(int contentDescRes) {
            ActionBar ab = ActionBarActivityDelegate.this.getSupportActionBar();
            if (ab != null) {
                ab.setHomeActionContentDescription(contentDescRes);
            }
        }
    }
}

