// 11_04_host_scroll_lock

// Nienijszy szkic oparto na przykadzie LCDlbd doczonym dobiblioteki USB_Host_Shield


#include <Spi.h>
#include <Max3421e.h>
#include <Usb.h>


/* dane klawiatury pobrane z deskryptora konfiguracji */
#define KBD_ADDR        1
#define KBD_EP          1
#define KBD_IF          0
#define EP_MAXPKTSIZE   8
#define EP_POLL         0x0a

/**/
EP_RECORD ep_record[ 2 ];  //punkt wymiany danych klwiatury

char buf[ 8 ] = { 0 };      //bufor klawiatury
char old_buf[ 8 ] = { 0 };  //ostatnio odebrane dane

char leds = 0;


MAX3421E Max;
USB Usb;

void setup() {
  // okrela ilo wierszy i kolumn wywietlacza LCD:
  Serial.begin( 9600 );
  Serial.println("Start");
  Max.powerOn();
  delay( 200 );
}

void loop() {
    Max.Task();
    Usb.Task();
    if( Usb.getUsbTaskState() == USB_STATE_CONFIGURING ) {  //czeka na stan adresujcy
        kbd_init();
        Usb.setUsbTaskState( USB_STATE_RUNNING );
    }
    if( Usb.getUsbTaskState() == USB_STATE_RUNNING ) {  //poll the keyboard  
        toggleLEDs();
        delay(500);
    }
}
/* Inicjalizuje klawiatur */
void kbd_init( void )
{
  byte rcode = 0;  //zwraca kod
  ep_record[ 0 ] = *( Usb.getDevTableEntry( 0,0 ));  //kopiuje parametry punktu wymiany 0
  ep_record[ 1 ].MaxPktSize = EP_MAXPKTSIZE;
  ep_record[ 1 ].Interval  = EP_POLL;
  ep_record[ 1 ].sndToggle = bmSNDTOG0;
  ep_record[ 1 ].rcvToggle = bmRCVTOG0;
  Usb.setDevTableEntry( 1, ep_record );              //docza parametr kbd.endpoint do devtable
  /* Configure device */
  rcode = Usb.setConf( KBD_ADDR, 0, 1 );                    
  if( rcode ) {
      Serial.print("Blad podczas proby skonfigurowania klawiatury. Zwrocono kod:");
      Serial.println( rcode, HEX );
      while(1);  //stop
  }
  /* Set boot protocol */
  rcode = Usb.setProto( KBD_ADDR, 0, 0, 0 );
  if( rcode ) {
      Serial.print("Blad podczas proby skonfigurowania protokou rozruchowego. Zwrocono kod:");
      Serial.println( rcode, HEX );
      while( 1 );  //stop
  }
  Serial.println("Klawiatura zainicjowana");
  delay(2000);
}


void toggleLEDs( void )
{
  if (leds == 0) {
    leds = 0b00000111;
  }
  else {
    leds = 0;
  }
  Usb.setReport( KBD_ADDR, 0, 1, KBD_IF, 0x02, 0, &leds );
}



