// 08_03_OneWire_DS18B20_2

#include <OneWire.h>
#include <DallasTemperature.h>

const int busPin = 10;

OneWire bus(busPin);
DallasTemperature sensors(&bus);
DeviceAddress sensor1;
DeviceAddress sensor2;

void setup()
{
  Serial.begin(9600);
  sensors.begin();
  if (!sensors.getAddress(sensor1, 0)) 
  {
    Serial.println("Nie znaleziono pierwszego chipu DS18B20!");
  }
  if (!sensors.getAddress(sensor2, 1)) 
  {
    Serial.println("Nie znaleziono drugiego chipu DS18B20!");
  }
}

void loop()
{
  sensors.requestTemperatures();
  float tempC1 = sensors.getTempC(sensor1);
  float tempC2 = sensors.getTempC(sensor2);
  Serial.print(tempC1);
  Serial.print(" ");
  Serial.println(tempC2);
  delay(1000);
}
