// 14_05_esp8266_server

#include <ESP8266WiFi.h>
#include <ESP8266WebServer.h>
#include <ESP8266mDNS.h>

const char* ssid = "";
const char* password = "";
const int relayPin = D0;

ESP8266WebServer server(80);

void setup() 
{
  pinMode(relayPin, OUTPUT);
  Serial.begin(9600);
  connectToWiFi();
  server.on("/", handleRoot);
  server.begin();
  Serial.println("Serwer HTTP został uruchomiony");
}

void loop() 
{
  server.handleClient();
}

void connectToWiFi() 
{
  Serial.print("\n\nŁączenie z ");
  Serial.println(ssid);
  WiFi.begin(ssid, password);
  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.print(".");
  }
  Serial.println("\nPołączono z siecią Wi-Fi");  
  Serial.print("Adres IP: ");
  Serial.println(WiFi.localIP());
}

void handleRoot() 
{
  Serial.println("Otrzymano żądanie");
  if (server.arg(0)[0] == '1') 
  {
    digitalWrite(relayPin, HIGH);
  }
  else 
  {
    digitalWrite(relayPin, LOW);
  }
  String msg = "";
  msg += "<html><body>\n";
  msg += "<h1>Zdalny przekaźnik</h1>";
  msg += "<h2><a href='?a=1'/>Włącz</a></h2>";
  msg += "<h2><a href='?a=0'/>Wyłącz</a></h2>";
  msg += "</body></html>";
  
  server.send(200, "text/html", msg);
}
