#include <gtest/gtest.h>
#include <cucumber-cpp/autodetect.hpp>

#include <Sum.h>

using cucumber::ScenarioScope;

struct SumCtx {
  Sum sum;
  int a;
  int b;
  int result;
};

GIVEN("^Wprowadzone parametry to (\\d+) i (\\d+)$",
      (const int a, const int b)) {
  ScenarioScope<SumCtx> context;

  context->a = a;
  context->b = b;
}

WHEN("^dodaję je do siebie") {
  ScenarioScope<SumCtx> context;

  context->result = context->sum.sum(context->a, context->b);
}

THEN("^wynikiem powinna być liczba (.*)$", (const int expected)) {
  ScenarioScope<SumCtx> context;

  EXPECT_EQ(expected, context->result);
}
