import os

from conans import ConanFile, CMake, tools


class CustomerTestConan(ConanFile):
    settings = "os", "compiler", "build_type", "arch"
    generators = "CMakeDeps"

    def imports(self):
        self.copy("*.dll", dst="bin", src="bin")
        self.copy("*.dylib*", dst="bin", src="lib")
        self.copy('*.so*', dst='bin', src='lib')

    def build(self):
        cmake = CMake(self)
        # Bieżący katalog to "test_package/build/<build_id>", a plik 
        # CMakeLists.txt znajduje się w katalogu "test_package". 
        cmake.configure()
        cmake.build()

    def test(self):
        if not tools.cross_building(self.settings):
            self.run(".%sexample" % os.sep)
