# Architektura-oprogramowania-Cpp
Architektura oprogramowania bez tajemnic - Wydawnictwo Helion

## Rozdział 5: Wykorzystywanie cech języka C++

### Wymagania wstępne

Zainstaluj następujące oprogramowanie:

- CMake 3.15
- Conan 1.43
- GCC 11

Jeśli pracujesz w systemie Linux albo korzystasz z WSL, skonfiguruj profil narzędzia Conan o nazwie hosacpp i elementy zdalne przez wydanie poleceń:

```bash
conan profile new hosacpp || true
conan profile update settings.compiler=gcc hosacpp
conan profile update settings.compiler.libcxx=libstdc++11 hosacpp
conan profile update settings.compiler.version=11 hosacpp
conan profile update settings.arch=x86_64 hosacpp
conan profile update settings.os=Linux hosacpp
```

Jeśli Twoim domyślnym kompilatorem nie jest GCC 11, musisz też dodać:

```bash
conan profile update env.CXX=`which g++-11` hosacpp
conan profile update env.CC=`which gcc-11` hosacpp
```

### Budowanie

Aby zbudować projekt, przejdź najpierw do jego katalogu poleceniem cd, a potem uruchom:

```bash
mkdir build
cd build
conan install .. --build=missing -s build_type=Release -pr=hosacpp
cmake .. -DCMAKE_BUILD_TYPE=Release # typ budowy musi odpowiadać temu z narzędzia Conan
cmake --build .
```

Jeśli Twoim domyślnym kompilatorem nie jest GCC, możesz nakazać narzędziu CMake go użyć za pomogą flagi `CMAKE_CXX_COMPILER`.
Zamień pierwsze z powyższych wywołań na:

```bash
cmake .. -DCMAKE_BUILD_TYPE=Release -DCMAKE_CXX_COMPILER=`which g++-11`
```
