#include <Wire.h>
#include "DS1631.h"

uint8_t conf = 0x0C;
uint8_t dev1 = 0x90 >> 1;  
  
DS1631 Tmp(dev1); // Funkcja Wire.begin nie zostaa jeszcze uyta

void setup()
{
  Serial.println("Konfiguracja: Start");
//  uint8_t _ADDR = 0x90;
  Serial.begin(9600);
  Wire.begin();
  
  // wyczenie konwersji
 /*
  Wire.beginTransmission(dev1);
  Wire.write(0x22); // polecenie wyczenia konwersji
  Wire.endTransmission();
  (/
  */
  
  Tmp.stopConversion(dev1);
  
  // wywietlenie biecej konfiguracji
  
  Wire.beginTransmission(dev1);
  Wire.write(0xAC); // @AC : konfiguracja dostpu
  Wire.endTransmission();
  Wire.requestFrom(dev1,(uint8_t)1); // Odczyt 1 bajtu
  Wire.available();
  int AC = Wire.read(); // odebranie bajtu
  Serial.print("Urzadzenie: ");
  Serial.print(0x90);
  Serial.print(" : " );
  Serial.println(dev1);
  Serial.print("Reczny odczyt: ");
  Serial.print(AC);
  Serial.print(" Hex: ");
  Serial.print(AC, HEX);
  Serial.print(" BIN: ");
  Serial.println(AC, BIN);

  // Zapis do rejestru "Access Config"
  Wire.beginTransmission(dev1);
  Wire.write(0xAC); // @AC : konfiguracja dostpu
  Wire.write(0x0C); // ciga konwersja z 12-bitow dokadnoci
  Wire.endTransmission();
  
  
  Serial.print("Tymcz. bieca konfiguracja: ");
  int config_b = Tmp.getConfig(dev1);
  Serial.print(config_b,DEC);
  Serial.print(" Hex: ");
  Serial.print(config_b, HEX);
  Serial.print(" BIN: ");
  Serial.println(config_b, BIN);
  
  Serial.print("Tymcz. dana konfiguracja: ");
  Serial.print(conf,DEC);
  Serial.print(" Hex: ");
  Serial.print(conf, HEX);
  Serial.print(" BIN: ");
  Serial.println(conf, BIN);
  
  Tmp.setConfig(dev1, conf);

  config_b = Tmp.getConfig(dev1);
  Serial.print("Konfiguracja: ");
  Serial.print(config_b,DEC);
  Serial.print(" Hex: ");
  Serial.print(config_b, HEX);
  Serial.print(" BIN: ");
  Serial.println(config_b, BIN);
  Serial.println("Konfiguracja: zakoczona");
}

void loop()
{
  Serial.print("Temp. C: ");
  float temp = Tmp.getTemp(dev1);
  Serial.print(temp, 4);
  Serial.print(" temp. F: ");
  Serial.println((temp*9/5) + 32);;
  delay(1000); 
}


