// Listing 10.4. Standard SABB
const byte myAddress = '2'; // zakres adresw 0  255
const int bufferSize = 64;  // 64 odpowiada dugoci bufora portu szeregowego
byte txBuffer[bufferSize];  // bufor na dane do wysania do urzdzenia slave
byte rxBuffer[bufferSize];  // bufor na dane odebrane z urzdzenia slave
volatile byte rxBufferSlave[bufferSize]; // przechowywanie danych, jeeli urzdzenie jest slave
volatile boolean flag = true; // zmiana flagi stanu diody LED

void setup() {
  Serial.begin(115200); // otwarcie poczenia szeregowego
  PORTB |= 0b00000100; // ustawienie stanu wysokiego na linii SS
  while (!(PINB & 0b00000100)); // oczekiwanie na inicjalizacj, jeeli stan na linii SS jest zewntrznie ustawiony na niski 
  initSPI(); // przygotowanie do poczenia z sieci
  txBuffer[0] = 0b00000000; // wpisanie bajtu zerowego do bufora wysyajcego
  transferSPI(1); // wysanie bajtu zerowego, aby zwolni oczekujce urzdzenia
  initSPI(); // ustaw stan jaowy na komunikacji pyta-pyta
  Serial.println("Gotowy"); // informacja o penej inicjalizacji pyty
}
void loop() {
  if (Serial.available()) {
    delay(1000); // oczekiwanie 1 s na odebranie danych szeregowych
    int count = 1; // zapisanie danych w tabeli, poczwszy od 2. pozycji
    txBuffer[0] = 0b00000000; // wysanie najpierw bajtu zerowego 
    while (Serial.available()) {
      txBuffer[count] = Serial.read(); // zapisanie bufora szeregowego do txBuffer
      count++; 
    }
    Serial.flush(); // wyczyszczenie bufora szeregowego
    transferSPI(count); // wysanie i odebranie danych jako master
    printBuffer(count); // wywietlenie danych wysanych i odebranych
    initSPI(); // powrt do stanu jaowego
  }
  if (flag == true ) { // flaga ustawiona na true, jeeli urzdzenie zaadresowane przez mastera
    PORTB = (~(PINB << 7) >> PINB7); // zmiana stanu diody LED
    flag = false; // skasowanie flagi
  }
}
void initSPI() { // ustawienie stanu jaowego poczenia
  DDRB |= 0b00000001;  // wyjcie LED
  DDRB &= 0b11000011;  // wejcie MOSI MISO SCK SS
  PORTB |= 0b00000100; // ustawienie stanu wysokiego na linii slave select
  PORTB &= 0b11000111; // ustawienie stanu niskiego na linii MISO MOSI SCK
  SPCR = 0b11000000;   // SPIE, SPE, SLAVE, MODE0, CLOCK DIV_4
  sei(); // globalne wczenie przerwa
}

int printBuffer(int nBytes) { // wywietlenie danych wysyanych i odbieranych, jeeli urzdzenie jest typu master
  Serial.println();
  Serial.write (txBuffer, nBytes);
  Serial.println();
  Serial.write (rxBuffer, nBytes);
  Serial.println();
}
int transferSPI(int txBytes) {
  cli(); // globalne wyczenie przerwa
  SPCR |= 0b00010000;  // ustawienie trybu SPI master
  DDRB |= 0b00101100;  // wyjcie MOSI SCK SS
  DDRB &= 0b11101111;  // wejcie MISO
  PORTB &= 0b11111011; // stan wysoki na linii slave select
  int count = 0;
  delay(50); // czekanie, a doczone urzdzenia obsu przerwanie; 50 jest bardzo bezpieczn wartoci
  while (count < txBytes) { // wykonywanie ptli, a wszystkie dane zostan wysane
    SPDR = txBuffer[count]; // rozpoczcie wysyania bajtu przez wpisanie go do rejestru SPDR
    while (!(SPSR & (1 << SPIF))); // oczekiwanie na zakoczenie transmisji
    rxBuffer[count] = SPDR; // odczyt odebranego bajtu
    count++;
  }
  PORTB |= 0b00000100; // ustawienia stanu wysokiego na linii SS
}
ISR(SPI_STC_vect) { // wektor przerwania SPI
  int count = 0;
  if (!(PINB & 0b00000100)) { // wejcie, jeeli stan SS jest niski
    while (!(PINB & 0b00000100)) { // ptla, dopki stan SS jest niski
      while (!(SPSR & (1 << SPIF))); // oczekiwanie na zakoczenie transmisji danych
      rxBufferSlave[count] = SPDR; // odczyt rejestru  SPDR
      if (rxBufferSlave[0] == myAddress) {DDRB |= 0b00010000;} // ustawienie linii MISO jako wyjcia, jeeli adres si zgadza
      SPDR = rxBufferSlave[count]; // wpisanie danych do wysania do rejestru SPDR
      count++;
    }
    if (rxBufferSlave[0] == myAddress) {flag = true;} // ustawienie flagi zmiany diody LED, jeeli adres si zgadza
    initSPI(); // powrt do stanu jaowego poczenia
  }
}

