/*
* Prosta biblioteka do rcznego sterowania silnikiem
* Copyright 2012 by Zipwhip. 
* Moesz dowolnie uywa i modyfikowa kod na swoje potrzeby
* http://blog.zipwhip.com/2012/03/28/manual-control-of-a-servo-on-the-arduino-for-the-zipwhip-textspresso-machine/
* Przekonwertowane na obiekt przez Rick Anderson http://github.com/ricklon/attinysecretknock
*/

#include "attinyservo.h"


int lenMicroSecondsOfPeriod = 20 * 1000; // 20 milisekund (ms)
int lenMicroSecondsOfPulse = 1.8 * 1000; // 1.0 ms to 0 stopni

void servoBegin()
{
   pinMode(SERVO_PIN, OUTPUT); 
}

void  moveServo(int lenMicroSecondsOfPulse, int delayMillis)
{

  int currentMillis = millis();
  int previousMillis = 0;

  lenMicroSecondsOfPulse = lenMicroSecondsOfPulse*1000;
  while(currentMillis - previousMillis > delayMillis)
  {
    previousMillis = currentMillis;  
	// Silnik jest napdzany impulsami 20 ms
    // Impuls 1.0 ms ustawia silnik w pooeniu 0 stopni
    // Impuls 1.5 ms ustawia silnik w pooeniu 90 stopni
    // Impuls 2.0 ms ms ustawia silnik w pooeniu 180 stopni
    // Zwiksz napicie, aby wysa impuls
    digitalWrite(SERVO_PIN, HIGH);

    // Opnienie pomidzy impulsami
    delayMicroseconds(lenMicroSecondsOfPulse);

    // Obni napicie przez pozostay czas impulsu
    digitalWrite(SERVO_PIN, LOW);

	// Ptla opniajca na pozosta czas
    // dziki czemu nastpny impuls nie jest wysyany za wczenie, ani za pno
    delayMicroseconds(lenMicroSecondsOfPeriod - lenMicroSecondsOfPulse);  
  }
}

