/*
 * Projekt sekretnego pudeka przygotowany do Arduino 1.0 z ukadem Attiny85
 * Licencja GPL
 Wykrywa sekwencj pukania i jeeli jest poprawna, uruchamia silnik otwierajcy pudeko
 
 Steve Hoefer http://grathio.com
 Wersja 0.1.10.20.10
 Licencja Creative Commons Attribution-Noncommercial-Share Alike 3.0
 http://creativecommons.org/licenses/by-nc-sa/3.0/us/
 (W skrcie: Moesz robi z kodem, co chcesz, ale umie w nim cztery powysze wiersze i nie sprzedawaj go w adnej postaci bez porozumienia ze mn.)
* Przekonwertowana na obiekt przez Rick Anderson http://github.com/ricklon/attinysecretknock
 */

#ifndef SecretKnock_h
#define SecretKnock_h

#if defined(ARDUINO) && ARDUINO  >= 100
#include "Arduino.h"
#include "pins_arduino.h"
#else
#include "WProgram.h"
#include "pins_arduino.h"
#endif

#define MAX_KNOCKS 20


class SecretKnock 
{

private:
public:

  // Stae do tuningu. Mog to by zmienne i skojarzone z potencjometrem do regulacji, itp.
   int threshold;         // Minimalny poziom sygnau z czujnika piezoelektrycznego oznaczajcy pukanie
   int rejectValue;       // Jeeli wystukany szyfr rni si od wzorca o tyle procent, nie otwieramy pudeka.
   int averageRejectValue;// Jeeli redni czas pukania rni si o tyle procent, nie otwieramy pudeka.
   int knockFadeTime;     // Czas w milisekundach na zaniknicie puknicia przed nasuchiwaniem nastpnego (timer wytumienia)
   int lockTurnTime;      // Czas w milisekundach na uruchomienie silnika i wykonanie poowy obrotu
   int lockMotor;         
   int knockComplete;      // Maksymalny czas oczekiwania, po ktrym uznajemy, e pukanie si zakoczyo


  // Zmienne
  int * knockReadings;       // Podczas pukania ta tabela jest wypeniana przerwami pomidzy pukniciami.
  int knockSensorValue;      // Ostatni odczyt z czujnika pukania.
  int programButtonPressed;  // Ustaw flag, aby zapamita ustawienie przycisku na kocu cyklu


  int secretCode[MAX_KNOCKS];

  // Definicje pinw
   int programSwitch;       // Jeeli stan jest wysoki, programujemy nowy kod
  //const int servoPin = 1;  // Pin 4 to PWM
   int knockSensor;         // Czujnik piezoelektryczny doczony do pinu ADC1.
   int redLED;              // Dioda LED oznaczajca status
   int greenLED;            // Dioda LED oznaczajca status
  //const int speakerPin = 2;


  SecretKnock(void);

  void begin(int * initKnocks);

  void checkKnock();

  void listenToSecretKnock();

  void triggerDoorUnlock();

  boolean validateKnock();

  void openDoor();

  void blinkSuccess();

  void playSuccess();

};
#endif

