// Projekt nr 56  stosowanie cyfrowego rezystora nastawnego

#include "SPI.h" // niezbdna biblioteka
int ss=10; // pin nr 10 bdzie peni funkcj pinu wyboru urzdzenia podrzdnego magistrali SPI
int del=200; // opnienie pomidzy kolejnymi krokami skali jasnoci diody LED

void setup()
{
   SPI.begin();
   pinMode(ss, OUTPUT); // pin SS
   digitalWrite(ss, HIGH); // pin SS jest aktywowany stanem LOW, zatem pocztkowo ustawiamy stan HIGH
   SPI.setBitOrder(MSBFIRST);
   // ukad MCP4162 wymaga wysyania najbardziej znaczcego bitu (MSB) jako pierwszego
}

void setValue(int value)
{
   digitalWrite(ss, LOW);
   SPI.transfer(0); // wysya bajt rozkazu
   SPI.transfer(value); // wysya bajt wartoci (od 0 do 255)
   digitalWrite(ss, HIGH);
}

void loop()
{
   for (int a=0; a<256; a++)
   {
      setValue(a);
      delay(del);
   }
   for (int a=255; a>=0; a--)
   {
      setValue(a);
      delay(del);
   }
}
