// Projekt nr 17  implementacja binarnego quizu

#define DATA 6               // poczenie z pinem nr 14 rejestru 74HC595
#define LATCH 8              // poczenie z pinem nr 12 rejestru 74HC595
#define CLOCK 10             // poczenie z pinem nr 11 rejestru 74HC595

int number = 0;
int answer = 0;

void setup()
{
   pinMode(LATCH, OUTPUT);    // ustawia piny rejestru 74HC595
   pinMode(CLOCK, OUTPUT);
   pinMode(DATA, OUTPUT);
   Serial.begin(9600);
   randomSeed(analogRead(0)); // inicjalizuje generator liczb losowych
   displayNumber(0);          // wycza diody LED
}

void displayNumber(byte a)
{
   // wysya bajt w celu wywietlenia za pomoc diod LED
   digitalWrite(LATCH, LOW);
   shiftOut(DATA, CLOCK, MSBFIRST, a);
   digitalWrite(LATCH, HIGH);
}

void getAnswer()
{
   // pobiera odpowied od gracza
   int z = 0;
   Serial.flush();
   while (Serial.available() == 0)
   {
      // nie podejmuje adnych dziaa do momentu wykrycia danych w buforze portu szeregowego
   }
   // w buforze jest dostpny przynajmniej jeden znak  mona przystpi do oblicze
   while (Serial.available() > 0)
   {
      // przenosi poprzedni cyfr o jedn kolumn w lewo;
      // innymi sowy, jeli bufor zawiera dane, cyfra 1 jest zamieniana na liczb 10
      answer = answer * 10;
      // odczytuje nastpn cyfr z bufora i odejmuje znak '0',
      // aby przekonwertowa wpisany znak na odpowiedni cyfr
      z = Serial.read() - '0';
      // dodaje nowo odczytan cyfr do skumulowanej wartoci liczbowej
      answer = answer + z;
      // krtkie opnienie umoliwia przesanie ewentualnych dodatkowych danych wykrywanych przez Serial.available()
      delay(5);
   }
   Serial.print("Wpisana liczba: ");
   Serial.println(answer);
}

void checkAnswer()
{
   // sprawdza odpowied gracza i wywietla wynik
   if (answer == number) // prawidowa odpowied!
   {
      Serial.print("Odpowied prawidowa! ");
      Serial.print(answer, BIN);
      Serial.print(" to ");
      Serial.println(number);
      Serial.println();
   }
   else                  // bdna odpowied
   {
      Serial.print("Bdna odpowied! ");
      Serial.print(number, BIN);
      Serial.print(" to ");
      Serial.println(number);
      Serial.println();
   }
   answer = 0;
   delay(10000); // gracz ma troch czasu na analiz swojej odpowiedzi
}

void loop()
{
   number = random(256);
   displayNumber(number);
   Serial.println("Ile wyniesie ta liczba binarna w systemie dziesitnym? ");
   getAnswer();
   checkAnswer();
}
