// Projekt nr 57  wywietlanie daty i godziny na podstawie zegara czasu rzeczywistego
#include "Wire.h"
#define DS3232_I2C_ADDRESS 0x68

// Konwertuje liczby dziesitne na zakodowane wartoci binarne
byte decToBcd(byte val)
{
   return( (val/10*16) + (val%10) );
}

// Konwertuje zakodowane wartoci binarne na liczby dziesitne
byte bcdToDec(byte val)
{
   return( (val/16*10) + (val%16) );
}

void setup()
{
   Wire.begin();
   Serial.begin(9600);

   // ustawia pocztkow godzin:
   // DS3232 sekundy, minuty, godziny, dzie tygodnia, dzie miesica, miesic, rok
   setDS3232time(0, 56, 23, 3, 30, 10, 12);
}

void setDS3232time(byte second, byte minute, byte hour, byte dayOfWeek, byte
dayOfMonth, byte month, byte year)
{
   // ustawia dat i godzin w module DS3232
   Wire.beginTransmission(DS3232_I2C_ADDRESS);
   Wire.write(0); // okrela, e nastpna warto ma trafi do rejestru sekund
   Wire.write(decToBcd(second));     // ustawia sekundy
   Wire.write(decToBcd(minute));     // ustawia minuty
   Wire.write(decToBcd(hour));       // ustawia godziny
   Wire.write(decToBcd(dayOfWeek));  // ustawia dzie tygodnia (1 = niedziela, 7 = sobota)
   Wire.write(decToBcd(dayOfMonth)); // ustawia dzie miesica (od 1 do 31)
   Wire.write(decToBcd(month));      // ustawia miesic
   Wire.write(decToBcd(year));       // ustawia rok (od 0 do 99)
   Wire.endTransmission();
}

void readDS3232time(byte *second,
byte *minute,
byte *hour,
byte *dayOfWeek,
byte *dayOfMonth,
byte *month,
byte *year)
{
   Wire.beginTransmission(DS3232_I2C_ADDRESS);
   Wire.write(0); // ustawia wskanik rejestru DS3232 na pozycji 00h
   Wire.endTransmission();
   Wire.requestFrom(DS3232_I2C_ADDRESS, 7);
   // da siedmiu bajtw danych od moduu DS3232, poczwszy od rejestru 00h
   *second     = bcdToDec(Wire.read() & 0x7f);
   *minute     = bcdToDec(Wire.read());
   *hour       = bcdToDec(Wire.read() & 0x3f);
   *dayOfWeek  = bcdToDec(Wire.read());
   *dayOfMonth = bcdToDec(Wire.read());
   *month      = bcdToDec(Wire.read());
   *year       = bcdToDec(Wire.read());
}

void displayTime()
{
   byte second, minute, hour, dayOfWeek, dayOfMonth, month, year;
   // pobiera dane z moduu DS3232
   readDS3232time(&second, &minute, &hour, &dayOfWeek, &dayOfMonth, &month,
   &year);

   // wysya uzyskane dane do monitora portu szeregowego
   Serial.print(hour, DEC);
   // podczas wywietlania konwertuje warto zmiennej typu byte na liczb dziesitn
   Serial.print(":");
   if (minute<10)
   {
      Serial.print("0");
   }
   Serial.print(minute, DEC);
   Serial.print(":");
   if (second<10)
   {
      Serial.print("0");
   }
   Serial.print(second, DEC);
   Serial.print(" ");
   Serial.print(dayOfMonth, DEC);
   Serial.print("/");
   Serial.print(month, DEC);
   Serial.print("/");
   Serial.print(year, DEC);
   Serial.print(" Dzie tygodnia: ");
   switch(dayOfWeek){
      case 1:
         Serial.println("niedziela");
         break;
      case 2:
         Serial.println("poniedziaek");
         break;
      case 3:
         Serial.println("wtorek");
         break;
      case 4:
         Serial.println("roda");
         break;
      case 5:
         Serial.println("czwartek");
         break;
      case 6:
         Serial.println("pitek");
         break;
      case 7:
         Serial.println("sobota");
         break;
   }
}

void loop()
{
   displayTime(); // wywietla w oknie monitora portu szeregowego dat i godzin pobrane z zegara czasu rzeczywistego
   delay(1000);   // cykl jest powtarzany co sekund
}
