#include <Wire.h>

const int magnetometer_address = 0x1E;  
int magVals[3];

float magx_scale, magy_scale, magz_scale, magx_max, magy_max, magz_max;

#define HMC_POS_BIAS 1
#define HMC_NEG_BIAS 2
#define HMC58X3_R_XM 3

#define HMC58X3_R_CONFA 0  
#define HMC58X3_R_CONFB 1
#define HMC58X3_R_MODE 2
#define HMC58X3_R_XM 3
#define HMC58X3_R_XL 4

void writemem(uint8_t dev_address, uint8_t _addr, uint8_t _val) {
  Wire.beginTransmission(dev_address);  
  Wire.write(_addr);  
  Wire.write(_val);  
  Serial.print(Wire.endTransmission());  
}

void initMag()
{
  Serial.print(" inicjacja magnetometru ");
  writemem(magnetometer_address, HMC58X3_R_CONFA, 0x70);
  writemem(magnetometer_address, HMC58X3_R_CONFB, 0xA0);
  writemem(magnetometer_address, HMC58X3_R_MODE, 0x00);
}

void calibrateMag(unsigned char gain) {
  magx_scale=1;
  magy_scale=1;
  magz_scale=1;
  writemem(magnetometer_address, HMC58X3_R_CONFA, 0x010 + HMC_POS_BIAS); 
  writemem(magnetometer_address, HMC58X3_R_CONFB, gain << 5);

  float x, y, z, mx=0, my=0, mz=0, t=10;

  for (int i=0; i<(int)t; i++) {
    writemem(magnetometer_address, HMC58X3_R_MODE, 1);
    delay(100);

    readFromMagnet();  
    if (magVals[0] > mx) mx = magVals[0];
    if (magVals[2] > my) my = magVals[2];
    if (magVals[1] > mz) mz = magVals[1];
  }

  float max=0;
  if (mx>max) max=mx;
  if (my>max) max=my;
  if (mz>max) max=mz;

  magx_max = mx;
  magy_max = my;
  magz_max = mz;
  magx_scale = max/mx;  
  magy_scale = max/my;
  magz_scale = max/mz;
  writemem(magnetometer_address, HMC58X3_R_CONFA, 0x010);
  delay(10);

  unsigned char mode = 0;  
  writemem(magnetometer_address, HMC58X3_R_MODE, mode);
  delay(100);
}

void readFromMagnet()
{
  Wire.beginTransmission(magnetometer_address);
  Wire.write(HMC58X3_R_XM);  
  Wire.endTransmission();

  Wire.beginTransmission(magnetometer_address);
  Wire.requestFrom(magnetometer_address, 6);
  if(6 == Wire.available()) {
    magVals[0] = (Wire.read() << 8) | Wire.read();  
    magVals[2] = (Wire.read() << 8) | Wire.read();
    magVals[1] = (Wire.read() << 8) | Wire.read();

    magVals[0] /= magx_scale;
    magVals[2] /= magy_scale;
    magVals[1] /= magz_scale;
  }
  Wire.endTransmission();
}

void setup()
{
  // Uruchomienie magnetometru
  initMag();
  calibrateMag(4);
}

void loop()
{
  readFromMagnet();
  char str[3];
  itoa(magVals[2], str, 10);  
  Serial.print('x'); // Wyświetlenie 0
  Serial.print(str[0]);
  Serial.print(str[1]);
  Serial.print(str[2]);
  delay(100);
}
