#include <avr/pgmspace.h>

#include <avrpins.h>
#include <max3421e.h>
#include <usbhost.h>
#include <usb_ch9.h>
#include <Usb.h>
#include <usbhub.h>
#include <avr/pgmspace.h>
#include <address.h>
#include <Xboxhidboot.h> // Doczenie biblioteki Xboxhidboot

#include <printhex.h>
#include <message.h>
#include <hexdump.h>
#include <parsetools.h>

// Deklaracja klasy parsera
class XboxRptParser : 
public XboxReportParser
{

protected:

  // Deklaracje funkcji obsugi przyciskw
  virtual void onDPadUp 	        (XBOXINFO *mi);
  virtual void onDPadDown 	        (XBOXINFO *mi);
  virtual void onDPadLeft 	        (XBOXINFO *mi);
  virtual void onDPadRight 	        (XBOXINFO *mi);
  virtual void onStartButton 	        (XBOXINFO *mi);
  virtual void onBackButton 	        (XBOXINFO *mi);
  virtual void onLeftStickPress 	(XBOXINFO *mi);
  virtual void onRightStickPress 	(XBOXINFO *mi);
  virtual void onButtonLB 	        (XBOXINFO *mi);
  virtual void onButtonRB 	        (XBOXINFO *mi);
  virtual void onButtonLogo 	        (XBOXINFO *mi);
  virtual void onButtonA	 	(XBOXINFO *mi);
  virtual void onButtonB	 	(XBOXINFO *mi);
  virtual void onButtonX	 	(XBOXINFO *mi);
  virtual void onButtonY	 	(XBOXINFO *mi);
  virtual void onLeftTrigger	        (XBOXINFO *mi);
  virtual void onRightTrigger	        (XBOXINFO *mi);
  virtual void onLeftStickMove	        (XBOXINFO *mi);
  virtual void onRightStickMove	        (XBOXINFO *mi);
};

// Funkcje wywietlajce status kadego przycisku
void  XboxRptParser::onDPadUp (XBOXINFO *mi)
{
  Serial.println("Pad D w gr");
};

void XboxRptParser::onDPadDown	(XBOXINFO *mi)	
{
  Serial.println("Pad D w d");
};
void XboxRptParser::onDPadLeft	(XBOXINFO *mi)	
{
  Serial.println("Pad D w lewo");
};
void XboxRptParser::onDPadRight	(XBOXINFO *mi)	
{
  Serial.println("Pad D w prawo");
};
void XboxRptParser::onStartButton (XBOXINFO *mi)	
{
  Serial.println("Przycisk Start");
};
void XboxRptParser::onBackButton	(XBOXINFO *mi)	
{
  Serial.println("Przycisk Wstecz");
};
void XboxRptParser::onLeftStickPress	(XBOXINFO *mi)	
{
  Serial.println("Nacinicie lewej manetki");
};
void XboxRptParser::onRightStickPress	(XBOXINFO *mi)	
{
  Serial.println("Nacinicie prawej manetki");
};
void XboxRptParser::onButtonLB	(XBOXINFO *mi)	
{
  Serial.println("Nacinity przycisk LB");
};
void XboxRptParser::onButtonRB	(XBOXINFO *mi)	
{
  Serial.println("Nacinity przycisk RB");
};
void XboxRptParser::onButtonLogo (XBOXINFO *mi)	
{
  Serial.println("Nacinity przycisk Logo");
};
void XboxRptParser::onButtonA	(XBOXINFO *mi)	
{
  Serial.println("Nacinity przycisk A");
};
void XboxRptParser::onButtonB	(XBOXINFO *mi)	
{
  Serial.println("Nacinity przycisk B");
};
void XboxRptParser::onButtonX	(XBOXINFO *mi)	
{
  Serial.println("Nacinity przycisk X");
};
void XboxRptParser::onButtonY	(XBOXINFO *mi)	
{
  Serial.println("Nacinity przycisk Y");
};
void XboxRptParser::onLeftTrigger (XBOXINFO *mi)	
{
  Serial.print("Lewy spust: ");
  Serial.println(mi->bmLeftTrigger, DEC); 
};
void XboxRptParser::onRightTrigger (XBOXINFO *mi)	
{
  Serial.print("Prawy spust: ");
  Serial.println(mi->bmRightTrigger, DEC); 
};

void XboxRptParser::onLeftStickMove (XBOXINFO *mi)
{
  Serial.print("Lewa manetka, o X = ");
  Serial.print(mi->bmLeftStickXAxis, DEC);
  Serial.print(" o Y = ");
  Serial.println(mi->bmLeftStickYAxis, DEC);
};
void XboxRptParser::onRightStickMove (XBOXINFO *mi)
{
  Serial.print("Prawa manetka, o X = ");
  Serial.print(mi->bmRightStickXAxis, DEC);
  Serial.print(" o Y = ");
  Serial.println(mi->bmRightStickYAxis, DEC);
};

USB     Usb; // Utworzenie instancji klasy USB
HIDBoot<HID_PROTOCOL_KEYBOARD>    Xbox(&Usb);
uint32_t next_time;
XboxRptParser Prs; // Utworzenie instancji klasy parsera Xbox

void setup()
{
  Serial.begin( 115200 );
  Serial.println("Uruchomienie Xbox");

  if (Usb.Init() == -1)
    Serial.println("OSC nie zosta uruchomiony.");

  delay( 200 );                   

  next_time = millis() + 5000;

  Xbox.SetReportParser(0, (HIDReportParser*)&Prs); // Konfiguracja parsera
}

void loop()
{
  Usb.Task(); // Metoda Task sprawdza urzdzenie USB i zwraca status jego przyciskw
}
