#include <math.h>

const int FREQOUT_PIN = 4;

const int RANGER_PIN = 9;

const float A = 14080;
const float AS = 14917.2;
const float B = 15804.3;
const float C = 16744;
const float CS = 17739.7;
const float D = 18794.5;
const float DS = 19912.1;
const float E = 21096.2;
const float F = 22350.6;
const float FS = 23679.6;
const float G = 25087.7;
const float GS = 26579.5;

float lastDistance;
float notes[12] = { A, AS, B, C, CS, D, DS, E, F, G, GS };

float read_gp2d12_range(byte pin)
{
  int distance = analogRead(pin);
  if (distance < 3)
    return -1; // bdna warto

  return (6787.0 /((float) distance - 3.0)) - 4.0;
}

void freqout(int frequency, int time)  // Okrelenie czstotliwoci i dugoci impulsu 
{
  int hperiod;
  long cycles, i;
  pinMode(FREQOUT_PIN, OUTPUT);
  hperiod = (500000 / frequency) - 7;
  cycles = ((long) frequency * (long) time) / 1000;

  for (i=0; i<= cycles; i++)
  {
    digitalWrite(FREQOUT_PIN, HIGH);
    delayMicroseconds(hperiod);
    digitalWrite(FREQOUT_PIN, LOW);
    delayMicroseconds(hperiod - 1);
  }
  pinMode(FREQOUT_PIN, INPUT);  // Wyczenie pinu w celu uniknicia zakce 
}

void setup()
{
  pinMode(RANGER_PIN, INPUT);
  Serial.begin(57600);
  lastDistance = 0;
}

void loop()
{
  float distance = read_gp2d12_range(RANGER_PIN);
  Serial.print(distance);

  freqout( notes[map(distance, 10, 80, 0, 11)], lastDistance - distance * 50 );

  lastDistance = distance;
}
