/*
 * Szkic pulse_generator
 */
#include <TimerOne.h>

const char SET_PERIOD_HEADER      = 'p';
const char SET_FREQUENCY_HEADER   = 'f';
const char SET_PULSE_WIDTH_HEADER = 'w';
const char SET_DUTY_CYCLE_HEADER  = 'c';

const int outPin = 9; // Numer pinu; na płytkach Teensy 3.x użyj pinów 3-4, a na Arduino Mega pinów 11-13

long period = 40; // 40-mikrosekundowa długość (25 kHz)
int duty = 512;   // Współczynnik wypełnienia impulsu jako wartość z zakresuod 0 do 1023, 512 to 50% wypełnienia

void setup()
{
  Serial.begin(9600);
  pinMode(outPin, OUTPUT);
  Timer1.initialize(period); // Inicjalizacja Timer1, 10000 mikrosekund
  Timer1.pwm(outPin, duty); // Funkcja PWM na pinie wyjścia
  instructions();
}

void loop()
{
  processSerial();
}

void processSerial()
{
  static long val = 0;

  if (Serial.available())
  {
    val = Serial.parseInt(); // Znalezienie pierwszej liczby
    if (val)
    {
      char ch = Serial.read();
      switch(ch)
      {
        case SET_PERIOD_HEADER:
          period = val;
          Serial.print("Ustawianie okresu na ");
          Serial.println(period);
          Timer1.setPeriod(period);
          Timer1.pwm(outPin, duty);
          show();
          break;
        case SET_FREQUENCY_HEADER:
          if(val > 0)
          {
            Serial.print("Ustawianie częstotliwości na ");
            Serial.println(val);
            period = 1000000 / val;
            Timer1.setPeriod(period);
            Timer1.pwm(outPin, duty);
          }
          show();
          break;
        case SET_PULSE_WIDTH_HEADER:
          if( val < period && val > 0) {
            long width = val;
            Serial.print("Ustawianie szerokości impulsu na ");
            Serial.println(width);
            duty = map(width, 0,period, 0,1023);
            Timer1.pwm(outPin, duty);
           }
          else
             Serial.println("Szerokość impulsu jest zbyt duża dla obecnie ustawionego okresu.");
          show();
          break;
        case SET_DUTY_CYCLE_HEADER:
          if( val >0 && val < 100)
          {
            Serial.print("Ustawianie współczynnika wypełnienia impulsu na ");
            Serial.println(val);
            duty = map(val, 0,99, 0,1023);
            Timer1.pwm(outPin, duty);
            show();
          }
      }
    }
  }
}

void show()
{
  Serial.print("Okres wynosi ");
  Serial.println(period);
  Serial.print("Współczynnik wypełnienia impulsu wynosi ");
  Serial.print(map(duty, 0,1023, 0,99));      
  Serial.println("%");
  Serial.println();
  instructions();
}

void instructions()
{
  Serial.println("Wyślij jeden z poniższych znaków poprzedzonych wartością danego ustawienia:");
  Serial.println(" p - ustawia okres w mikrosekundach");
  Serial.println(" f - ustawia częstotliwość w hercach");
  Serial.println(" w - ustawia szerokość impulsu w mikrosekundach");
  Serial.println(" c - ustawia współczynnik wypełnienia impulsu w procentach");
  Serial.println("\n(Współczynnik wypełnienia impulsu może mieć tylko jedno miejsce po przecinku)\n");
}
