/*
 * Szkic ch15_serve_large_web_pages
 *
 * Odpowiada na zawarte w adresie URL żądania, które zmieniają cyfrowe i analogowe piny wyjścia,
 * wyświetla liczbę zmienionych pinów oraz wartości analogowych pinów wejścia
 *
 * http://192.168.1.177/analogowy/ — wyświetla dane analogowych pinów
 * http://192.168.1.177/cyfrowy/ — wyświetla dane cyfrowych pinów
 * http://192.168.1.177/zmiana/ — umożliwia zmianę stanu cyfrowych pinów
 *
 */


// Usuń znaczniki komentarza tylko sprzed jednej z poniższych linijek
#include "USE_NINA.h"     // Dla płytek z Wi-Fi
//#include "USE_Ethernet.h" // Dla płytek z Ethernetem
//#include "USE_ESP8266.h"  // Dla płytek ESP8266


#include <avr/pgmspace.h> // Dla pamięci flash
#define P(name) static const char name[] PROGMEM  // Deklaracja statycznego łańcucha znaków

const int MAX_PAGE_NAME_LEN = 11;  // Maksymalna liczba znaków w nazwie strony
char buffer[MAX_PAGE_NAME_LEN+1];  // Nazwa strony + końcowy null

void setup() 
{
  Serial.begin(9600);
 
  if (!configureNetwork()) // Uruchomienie sieci
  {
    Serial.println("Błąd konfiguracji sieci");
    while(1)
      delay(0); // Zatrzymanie programu; ESP8266 nie lubi nieskończonych pętli bez funkcji delay
  }
  server.begin();
  Serial.println(F("Gotowe"));
}

#define MSG_DELAY 10000
void loop() {
  static unsigned long nextMsgTime = 0;
  if (millis() > nextMsgTime)
  {
    Serial.print("Odwiedź http://");
    Serial.print(getIP()); Serial.println("/zmiana/");
    nextMsgTime = millis() + MSG_DELAY;
  }

  maintain(); //  Utrzymanie dzierżawy DHCP, jeśli jest to konieczne

  client = server.available();
  if (client) 
  {
    int type = 0;
    while (client.connected()) 
    {
      if (client.available()) 
      {
        // GET, POST lub HEAD
        memset(buffer,0, sizeof(buffer)); // Wyczyszczenie buforu
        if(client.readBytesUntil('/', buffer,MAX_PAGENAME_LEN))
        { 
          if(strcmp(buffer, "GET ") == 0 )
            type = 1;
          else if(strcmp(buffer,"POST ") == 0)
            type = 2;
          // Wyszukiwanie nazwy strony
          memset(buffer,0, sizeof(buffer)); // Wyczyszczenie buforu
          if(client.readBytesUntil( '/', buffer,MAX_PAGENAME_LEN )) 
          {
            if(strcasecmp(buffer, "analogowy") == 0)
              showAnalog();
            else if(strcasecmp(buffer, "cyfrowy") == 0)
              showDigital();
            else if(strcmp(buffer, "zmiana")== 0)
              showChange(type == 2);
            else
              unknownPage(buffer);
          }
        }
        break;
      }
    }
    // Czas dla przeglądarki na odebranie danych
    delay(100);
    client.stop();
  }
}

void showAnalog()
{
  Serial.println(F("analogowy"));
  sendHeader("Piny analogowe");
  client.println("<h1>Piny analogowe</h1>");
  //  Wyświetlenie wartości każdego analogowego pinu wejścia
  client.println(F("<table border='1' >"));

  for (int i = 0; i < 6; i++) 
  {
    client.print(F("<tr><td>pin analogowy "));
    client.print(i);
    client.print(F(" </td><td>"));
    client.print(analogRead(i));
    client.println(F("</td></tr>"));
  }
  client.println(F("</table>"));
  client.println(F("</body></html>"));
}

// Dane w formacie MIME dla obrazków przestawiających stan włączony i wyłączony:
// Zobacz: http://www.motobit.com/util/base64-decoder-encoder.asp
P(led_on) =  "<img src=\"data:image/jpg;base64,"
"/9j/4AAQSkZJRgABAgAAZABkAAD/7AARRHVja3kAAQAEAAAAHgAA/+4ADkFkb2JlAGTAAAAAAf/b"
"AIQAEAsLCwwLEAwMEBcPDQ8XGxQQEBQbHxcXFxcXHx4XGhoaGhceHiMlJyUjHi8vMzMvL0BAQEBA"
"QEBAQEBAQEBAQAERDw8RExEVEhIVFBEUERQaFBYWFBomGhocGhomMCMeHh4eIzArLicnJy4rNTUw"
"MDU1QEA/QEBAQEBAQEBAQEBA/8AAEQgAGwAZAwEiAAIRAQMRAf/EAIIAAAICAwAAAAAAAAAAAAAA"
"AAUGAAcCAwQBAAMBAAAAAAAAAAAAAAAAAAACBAUQAAECBAQBCgcAAAAAAAAAAAECAwARMRIhQQQF"
"UWFxkaHRMoITUwYiQnKSIxQ1EQAAAwYEBwAAAAAAAAAAAAAAARECEgMTBBQhQWEiMVGBMkJiJP/a"
"AAwDAQACEQMRAD8AcNz3BGibKie0nhC0v3A+teKJt8JmZEdHuZalOitgUoHnEpQEWtSyLqgACWFI"
"nixWiaQhsUFFBiQSbiMvvrmeCBp27eLnG7lFTDxs+Kra8oOyium3ltJUAcDIy4EUMN/7Dnq9cPMO"
"W90E9kxeyF2d3HFOQ175olKudUm7TqlfKqDQEDOFR1sNqtC7k5ERYjndNPFSArtvnI/nV+ed9coI"
"ktd2BgozrSZO3J5jVEXRcwD2bbXNdq0zT+BohTyjgPp5SYdPJZ9NP2jsiIz7vhjLohtjnqJ/ouPK"
"co//2Q=="
"\"/>";

P(led_off) = "<img src=\"data:image/jpg;base64,"
"/9j/4AAQSkZJRgABAgAAZABkAAD/7AARRHVja3kAAQAEAAAAHgAA/+4ADkFkb2JlAGTAAAAAAf/b"
"AIQAEAsLCwwLEAwMEBcPDQ8XGxQQEBQbHxcXFxcXHx4XGhoaGhceHiMlJyUjHi8vMzMvL0BAQEBA"
"QEBAQEBAQEBAQAERDw8RExEVEhIVFBEUERQaFBYWFBomGhocGhomMCMeHh4eIzArLicnJy4rNTUw"
"MDU1QEA/QEBAQEBAQEBAQEBA/8AAEQgAHAAZAwEiAAIRAQMRAf/EAHgAAQEAAwAAAAAAAAAAAAAA"
"AAYFAgQHAQEBAQAAAAAAAAAAAAAAAAACAQQQAAECBQAHBQkAAAAAAAAAAAECAwAREhMEITFhoSIF"
"FUFR0UIGgZHBMlIjM1MWEQABAwQDAQEAAAAAAAAAAAABABECIWESA1ETIyIE/9oADAMBAAIRAxEA"
"PwBvl5SWEkkylpJMGsj1XjXSE1kCQuJ8Iy9W5DoxradFa6VDf8IJZAQ6loNtBooTJaqp3DP5oBlV"
"nWrTpEouQS/Cf4PO0uKbqWHGXTSlztSvuVFiZjmfLH3GUuMkzSoTMu8aiNsXet5/17hFyo6PR64V"
"ZnuqfqDDDySFpNpYH3E6aFjzGBr2DkMuFBSFDsWkilUdLftW13pWpcdWqnbBzI/l6hVXKZlROUSe"
"L1KX5zvAPXESjdHsTFWpxLKOJ54hIA1DZCj+Vx/3r96fCNrkvRaT0+V3zV/llplr9sVeHZui/ONk"
"H3dzt6cL/9k="
"\"/>";

void showDigital()
{
  Serial.println(F("cyfrowy"));
  sendHeader("Piny cyfrowe");
  client.println(F("<h2>Piny cyfrowe</h2>"));
  //  Wyświetlenie wartości każdego cyfrowego pinu wejścia
  client.println(F("<table border='1'>"));
  for (int i = 2; i < 8; i++) 
  {
    pinMode(i, INPUT_PULLUP);
    client.print(F("<tr><td>pin cyfrowy "));
    client.print(i);
    client.print(F(" </td><td>"));
    if(digitalRead(i) == HIGH)
      printP(led_off);
    else
      printP(led_on);
    client.println(F("</td></tr>"));
  }
  client.println(F("</table>"));

  client.println(F("</body></html>"));
}

void showChange(bool isPost)
{
  Serial.println(F("zmiana"));
  if(isPost)
  {
    Serial.println("metoda Post");
    client.find("\r\n\r\n"); // pomiń treść
    // Wyszukanie parametrów rozpoczynających się słowem "pin" i zatrzymanie na pierwszej pustej linii
    Serial.println(F("szukanie parametrów"));
    while(client.findUntil("pinD", "\r\n"))
    {
      int pin = client.parseInt();       // Numer pinu
      int val = client.parseInt();       // 0 lub 1
      Serial.print(pin);
      Serial.print("=");
      Serial.println(val);
      pinMode(pin, OUTPUT);
      digitalWrite(pin, val);
    }
  }
  sendHeader("Zmiana");

  // Tabela z przyciskami od 2 do 9
  // Od 2 do 5 to wejścia, pozostałe to wyjścia
  client.println(F("<table border='1'>"));

  // Wyświetlenie pinów wejścia
  for (int i = 2; i < 6; i++) // Piny 2-5 to wejścia
  {  
    pinMode(i, INPUT_PULLUP);
    client.print(F("<tr><td>cyfrowe wejście "));
    client.print(i);
    client.print(F(" </td><td>"));

    client.print(F("&nbsp </td><td>"));
    client.print(F(" </td><td>"));
    client.print(F("&nbsp </td><td>"));

    if(digitalRead(i) == HIGH)
      printP(led_off);
    else
      printP(led_on);
    client.println("</td></tr>");
  }

  // Wyświetlenie pinów wyjścia od 6 do 9
  // Zauważ, że piny 10-13 są używane przez nakładkę Ethernet 
  for (int i = 6; i < 10; i++) 
  {
    client.print(F("<tr><td>cyfrowe wyjście "));
    client.print(i);
    client.print(F(" </td><td>"));
    htmlButton( "Włącz", "pinD", i, "1");
    client.print(F(" </td><td>"));
    client.print(F(" </td><td>"));
    htmlButton("Wyłącz", "pinD", i, "0");
    client.print(F(" </td><td>"));

    if(digitalRead(i) == LOW)
      printP(led_off);
    else
      printP(led_on);
    client.println(F("</td></tr>"));
  }
  client.println(F("</table>"));
}

// Utworzenie przycisku HTML
void htmlButton( char * label, char *name, int nameId, char *value)
{
  client.print(F("<form action='/change/' method='POST'><p><input type='hidden' name='"));
  client.print(name);
  client.print(nameId);
  client.print(F("' value='"));
  client.print(value);
  client.print(F("'><input type='submit' value='"));
  client.print(label);
  client.print(F("'/></form>"));
}

void unknownPage(char *page)
{
  Serial.print(F("Strona : "));
  Serial.println(F("nieznana"));

  sendHeader("Nie rozpoznano strony");
  client.println(F("<h1>Nie rozpoznano strony</h1>"));
  client.println(page);
  client.println(F("</body></html>"));
}

void sendHeader(char *title)
{
  // Wysłanie standardowego nagłówka odpowiedzi HTTP
  client.println(F("HTTP/1.1 200 OK"));
  client.println("Typ zawartości: text/html");
  client.println();
  client.print(F("<html><head><title>"));
  client.println(title);
  client.println(F("</title><body>"));
}

void printP(const char *str)
{

  // Kopiowanie danych z pamięci flash do pamięci lokalnej
  // Kopiowanie w 32-bajtowych częściach w celu uniknięcia bardzo krótkich pakietów TCP/IP
  // z biblioteki webduino Copyright 2009 Ben Combee, Ran Talbott
  uint8_t buffer[32];
  size_t bufferEnd = 0;

  while (buffer[bufferEnd++] = pgm_read_byte(str++))
  {
    if (bufferEnd == 32)
    {
      client.write(buffer, 32);
      bufferEnd = 0;
    }
  }

  // Zapis pozostałych danych z pominięciem końcowego NUL
  if (bufferEnd > 1)
    client.write(buffer, bufferEnd - 1);
}
