/*
 * szkic wireless_transmit_struct
 * Wysyła wiadomość do innego modułu i czeka na odpowiedź.
 */
#include <SPI.h>
#include <RH_RF69.h>
#include <RHReliableDatagram.h>

#define MY_ADDR   2 // adres tego węzła
#define DEST_ADDR 1 // adres drugiego węzła

#define RF69_FREQ 915.0 // ustawienie obsługiwanej częstotliwości

// defnicja sterownika radia
#define RFM69_INT  3 
#define RFM69_CS   4
#define RFM69_RST  2
RH_RF69 rf69(RFM69_CS, RFM69_INT);

// obiekt zarządzający dostarczaniem wiadomości
RHReliableDatagram rf69_manager(rf69, MY_ADDR);

void setup() 
{
  Serial.begin(9600);

  pinMode(LED_BUILTIN, OUTPUT);    
  pinMode(RFM69_RST, OUTPUT);
  digitalWrite(RFM69_RST, LOW);

  Serial.println("Ponowne uruchamianie radia");
  digitalWrite(RFM69_RST, HIGH); delay(10);
  digitalWrite(RFM69_RST, LOW); delay(10);
  
  if (!rf69_manager.init()) 
  {
    Serial.println("Nie można uruchomić radia");
    while (1); // zatrzymanie programu
  }

  if (!rf69.setFrequency(RF69_FREQ)) {
    Serial.println("Nie można ustawić częstotliwości");
    while (1); // zatrzymanie programu
  }

  // Jeśli używasz wersji  modułu RF69 (RFM69HW/HCW) o dużej mocy, wymagany jest poniższy kod.
  rf69.setTxPower(20, true);  // zakres zasilania to: 14-20
  
  // Każdy węzeł musi używać tego samego klucza.
  uint8_t key[] = { 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
                    0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08};
  rf69.setEncryptionKey(key);
  
  Serial.print("Radio RFM69 działa na częstotliwości: ");
  Serial.print((int)RF69_FREQ); Serial.println(" MHz");
}

struct sensor {
  char header = 'H';
  char padding; // zapewnia to samo ustawienie struktury dla płytek 8-bitowych i 32-bitowych
  unsigned short int pin0;
  unsigned short int pin1;
  unsigned short int pin2;
} sensorStruct;
byte message[sizeof(sensorStruct)]; // zewnętrzna definicja danych wysyłanych kanałem radiowym, dzięki czemu nie jest umieszczana w stosie
void loop() 
{
  delay(1000); // Czekaj 1 sekundę.

  sensorStruct.pin0 = analogRead(A0);
  sensorStruct.pin1 = analogRead(A1);
  sensorStruct.pin2 = analogRead(A2);

  byte len = sizeof(sensorStruct);
  memcpy(message, &sensorStruct, len);

  if (!rf69_manager.sendtoWait((byte *)message, len, DEST_ADDR))
  {
    Serial.print("Błąd wysłania wiadomości do "); Serial.println(DEST_ADDR);
  }
}
