/*
 * Szkic analog_receive_series_2
 * Odczytuje analogową wartość z XBee and ustawia odpowiednią jasność diody LED
 */

// Usuń znaczniki komentarza tylko sprzed jednej z poniższych linijek
//#define MYSERIAL Serial // Uno, Nano i inne płytki AVR
#define MYSERIAL Serial1 // Nano Every, Uno WiFi R2, Leonardo oraz płytki ARM

#define MIN_CHUNK 24
#define OFFSET 18

const int ledPin = A5; // Analogowy pin 5

void setup() 
{
  MYSERIAL.begin(9600);
}

void loop() 
{
  if (MYSERIAL.available() >= MIN_CHUNK) // Czekanie na dane
  { 
    if (MYSERIAL.read() == 0x7E) // Początkowy separator ramy API
     { 
      // Pominięcie nieistotnych dla nas bajtów ramy API
      for (int i = 0; i < OFFSET; i++) 
      {
        MYSERIAL.read();
      }

      // Następne 2 bajty to górny i dolny bajt odczytu czujnika
      int analogHigh = MYSERIAL.read();
      int analogLow = MYSERIAL.read();
      int analogValue = analogLow + (analogHigh * 256);

      // Skalowanie jasności do zakresu PWM Arduino
      int brightness = map(analogValue, 0, 1023, 0, 255);

      // Zapalenie diody LED
      analogWrite(ledPin, brightness);
    }
  }
}
