/*
 * Szkic analog_receive_series_1_or_3
 * Odczytuje analogową wartość z XBee and ustawia odpowiednią jasność diody LED
 */

// Usuń znaczniki komentarza tylko sprzed jednej z poniższych linijek
//#define MYSERIAL Serial // Uno, Nano i inne płytki AVR
#define MYSERIAL Serial1 // Nano Every, Uno WiFi R2, Leonardo oraz płytki ARM

// Ustawienia dla XBee 3:
#define MIN_CHUNK 21
#define OFFSET 18

// Ustawienia dla XBee Seria 1:
//#define MIN_CHUNK 14
//#define OFFSET 10

const int ledPin = A5;

void setup() 
{
  MYSERIAL.begin(9600);
  delay(1000);
  configureRadio(); // Sprawdzenie zwróconej wartości, potrzebne do ewentualnej obsługi błędów
}

bool configureRadio() 
{
  // Ustawienie trybu poleceń na radiu
  MYSERIAL.flush();
  MYSERIAL.print("+++");
  delay(100);

  String ok_response = "OK\r"; // Oczekiwana odpowiedź

  // Zapisanie treści odpowiedzi do zmiennej response
  String response = String("");
  while (response.length() < ok_response.length()) 
  {
    if (MYSERIAL.available() > 0) 
    {
      response += (char) MYSERIAL.read();
    }
  }

  // Jeśli została otrzymana prawidłowa odpowiedź, skonfiguruj moduł radiowy i zwróć true
  if (response.equals(ok_response)) 
  {
    MYSERIAL.print("ATAP1\r"); // Wejście w tryb API
    delay(100);
    MYSERIAL.print("ATCN\r");  // Powrót do trybu danych
    return true;
  } 
  else 
  {
    return false; // To oznacza, że otrzymana odpowiedź była niepoprawna
  }
}

void loop() 
{
  if (MYSERIAL.available() >= MIN_CHUNK) // Czekanie na dane
  { 
     if (MYSERIAL.read() == 0x7E) // Początkowy separator ramy API
     { 
      // Pominięcie nieistotnych dla nas bajtów ramy API
      for (int i = 0; i < OFFSET; i++) 
      {
        MYSERIAL.read();
      }
      // Następne 2 bajty to górny i dolny bajt odczytu czujnika
      int analogHigh = MYSERIAL.read();
      int analogLow = MYSERIAL.read();
      int analogValue = analogLow + (analogHigh * 256);

      // Skalowanie jasności do zakresu PWM Arduino
      int brightness = map(analogValue, 0, 1023, 0, 255);

      // Zapalenie diody LED
      analogWrite(ledPin, brightness);
    }
  }
}
