/*
 * Szkic stepper_unipolar
 * Silnik krokowy sterowany za pomocą poleceń z portu szeregowego
 * Znak '+' lub '-' poprzedzony wartością liczbową obraca silnikiem
 */

#include <Stepper.h>

// Zmień tę wartość na liczbę kroków Twojego silnika
#define STEPS 24

// Utworzenie instancji klasy Stepper z określeniem
// Liczby kroków silnika i pinów, do których jest podłączony
Stepper stepper(STEPS, 2, 3, 4, 5);
int steps = 0;

void setup()
{
  stepper.setSpeed(300);    // Ustawienie prędkości silnika na 30 rpm
  Serial.begin(9600);
}

void loop()
{
  if ( Serial.available()) 
  {
    char ch = Serial.read();

    if(isDigit(ch)) // Czy zmienna ch jest liczbą?
    {
      steps = steps * 10 + ch - '0';        // Jeżeli tak, sumuj wartości
    }
    else if(ch == '+')
    {
      stepper.step(steps);
      steps = 0;
    }
    else if(ch == '-')
    {
      stepper.step(steps * -1);
      steps = 0;
    }
    else if(ch == 's')
    {
      stepper.setSpeed(steps);
      Serial.print("Ustawienie prędkości na "); Serial.println(steps);
      steps = 0;
    }
  }
}
