/*
 * Szkic computer_servo_control
 */
#include <Servo.h>  // Biblioteka obsługjąca serwomechanizmy

#define SERVOS 4 // Liczba serw
int servoPins[SERVOS] = {7,8,9,10}; // Serwa podłączone do pinów do 7 do 10

Servo myservo[SERVOS];

void setup()
{
  Serial.begin(9600);
  for(int i=0; i < SERVOS; i++)
  {
    myservo[i].attach(servoPins[i]);
  }
}

void loop()
{
  serviceSerial();
}

// Funkcja serviceSerial sprawdza port szeregowy i ustawia pozycję serwa na podstawie otrzymanych danych
// Oczekuje poleceń w następującej formie:
//
//  "180a" zapisuje 180 na serwie a
//  "90b zapisuje 90 na serwie b
//
void serviceSerial()
{
  if ( Serial.available()) 
  {
    int pos = Serial.parseInt();
    char ch = Serial.read();
    if(ch >= 'a' && ch < 'a' + SERVOS) // Jeśli zmienna ch jest poprawną literą oznaczającą serwo, 
    {
      Serial.print("Serwomotor "); Serial.print(ch - 'a');
      Serial.print(" ustawiony na "); Serial.println(pos);
      myservo[ch - 'a'].write(pos);  // zapisz pozycję na odpowiadającym tej literze serwomotorze
    }
  }
}
