/*
 *  Szkic bargraph_decay
 *  

 */

const int ledPins[] = {2, 3, 4, 5, 6, 7};
const int NbrLEDs = sizeof(ledPins) / sizeof(ledPins[0]);
const int analogInPin = A0; // Analogowy pin wejścia podłączony do zmiennego rezystora
const int decay = 10;       // Zwiększenie tej liczby zmnniejszy wartość wygaszania

// Zamień wartości dwóch poniższych definicji, jeśli katody są podłączone do masy
#define LED_ON  LOW
#define LED_OFF HIGH

// Wartość wygaszania
int storedValue = 0;

void setup() {
  for (int led = 0; led < NbrLEDs; led++)
  {
    pinMode(ledPins[led], OUTPUT);  // Ustawienie wszystkich pinów diod LED jako wyjścia
  }
}

void loop() {
  int sensorValue = analogRead(analogInPin);             // Odczyt wartości analogowej wejścia
  storedValue = max(sensorValue, storedValue);       // Jeśli wartość wygaszania jest wyższa, użyj wartości czujnika
  int ledLevel = map(storedValue, 10, 1023, 0, NbrLEDs); // Dostosowanie do liczby diod LED

  for (int led = 0; led < NbrLEDs; led++)
  {
    if (led < ledLevel ) {
      digitalWrite(ledPins[led], LED_ON);  // Włączenie pinów poniżej określonego poziomu
    }
    else {
      digitalWrite(ledPins[led], LED_OFF);   // Wyłączenie pinów powyżej określonego poziomu
    }
  }
  storedValue = storedValue - decay;     // Obniżenie wartości wygaszania o prędkość wygaszania
  delay(10);                             // Poczekaj 10 sekund przed wykonaniem kolejnego obiegu pętli
}
