/*
 * Szkic SoftwareSerialInput
 * Odczytuje dane z programowego portu szeregowego
 */

#include <SoftwareSerial.h>
const int rxpin = 8;                     // Pin używany do odbierania danych z GPS
const int txpin = 9;                    // Pin używany do wysyłania danych do GPS
SoftwareSerial serial_gps(rxpin, txpin); // Nowy port szeregowy na pinach 8 i 9

void setup()
{
  Serial.begin(9600); // Prędkość 9600 dla programowego portu szeregowego
  serial_gps.begin(9600); // Inicjalizacja portu, większość modułów GPS używa prędkości 9600 

}

void loop()
{
  if (serial_gps.available() > 0) // Czy został już odebrany jakiś znak?
  {
    char c = serial_gps.read();   // Jeśli tak, odczytaj go z GPS
    Serial.write(c);              // i wyświetl w konsoli
  }
}
