/*
 *  Szkic mqtt_subscribe
 */

// Usuń znaczniki komentarza tylko sprzed jednej z poniższych linijek
#include "USE_NINA.h"     // Dla płytek z Wi-Fi
//#include "USE_Ethernet.h" // Dla płytek z Ethernetem
//#include "USE_ESP8266.h"  // Dla płytek ESP8266

#include <PubSubClient.h>

const char* broker = "mqtt.eclipse.org"; // Adres brokera MQTT
const int interval = 5000;   // Liczba milisekund między wydarzeniami
unsigned int timePublished;  // Czas, który upłynął od ostatniej publikacji

PubSubClient psclient(client);

void callback(char* topic, byte* payload, unsigned int length) 
{
  Serial.print("Wiadomość na temat [");
  Serial.print(topic);
  Serial.print("] ");
  for (int i=0; i < length; i++) 
  {
    Serial.write(payload[i]);
  }
  Serial.println();
}

void setup()
{
  Serial.begin(9600);
  if (!configureNetwork()) // Uruchomienie sieci
  {
    Serial.println("Błąd konfiguracji sieci");
    while (1)
      delay(0); // Zatrzymanie programu; ESP8266 nie lubi nieskończonych pętli bez funkcji delay
  }
  psclient.setServer(broker, 1883);
  psclient.setCallback(callback);
}

void loop(void)
{

  if (!psclient.connected()) 
  {
    if (psclient.connect("arduinoCookbook3Sub")) 
    {    
      Serial.println("Subskrypcja tematu arck3/alog");
      psclient.subscribe("arck3/alog");
    }
  }
  if (psclient.connected())
    psclient.loop();
}
