/*
 * Szkic timealarms
 * Ten przykład wywołuje funkcje alarmowe o 8:30 i 17:45 oraz symuluje włączanie oświetlenia w nocy i wyłączanie w dzień
 * Jedna funkcja powtarzana jest co 15 s, a druga jedynie raz, po 10 s
 * Na początku czas ustawiany jest na 1 stycznia 2020, 8:29
 */


#include <TimeLib.h>
#include <TimeAlarms.h>

void setup()
{
  Serial.begin(9600);
  while(!Serial);
  Serial.println("Przykład TimeAlarms");
  Serial.println("Alarmy włącza się codziennie o 8:30 i 17:45");
  Serial.println("Jedna funkcja jest uruchamiana co 15 sekund");
  Serial.println("Druga funkcja jest uruchamiana tylko raz po 10 sekundach");
  Serial.println();

  setTime(8,29,40,1,1,2020); // Ustawienie czasu początkowego na 8:29:40, 1 stycznia 2020

  Alarm.alarmRepeat(8,30,0, MorningAlarm);  // 8:30 każdego dnia
  Alarm.alarmRepeat(17,45,0,EveningAlarm);  // 17:45 każdego dnia

  Alarm.timerRepeat(15, RepeatTask);            // Funkcja powtarzana co 15 s
  Alarm.timerOnce(10, OnceOnlyTask);            // Jednorazowa funkcja po 10 s
}

void MorningAlarm()
{
  Serial.println("Alarm: - wyłączenie świateł");
}

void EveningAlarm()
{
  Serial.println("Alarm: - włączenie świateł");
}

void RepeatTask()
{
  Serial.println("Alarm powtarzający się co 15 sekund");
}

void OnceOnlyTask()
{
  Serial.println("Jednorazowy alarm");
}

void loop()
{
  digitalClockDisplay();
  Alarm.delay(1000); // Czekaj 1 s  pomiędzy kolejnymi wyświetleniami zegara
}

// Dodanie początkowych zer do cyfr
String padDigits(int digit)
{
  String str = String("0") + digit; // Dodanie zera przez cyfrą
  return str.substring(str.length() - 2); // Usunięcie wszystkich znaków, oprócz dwóch ostatnich
}

void digitalClockDisplay(){
  String timestr = String(hour()) + ":" + padDigits(minute()) +
                   ":" + padDigits(second());
  Serial.println(timestr);
  
  String datestr = String(year()) + "-" + padDigits(month()) + 
                   "-" + padDigits(day()); 
  Serial.println(datestr);
}
