/*
 * Szkic tft_ST7735
 * Wyświetla tekst i poruszającą się po ekranie żółtą kulkę
 */

#include <Adafruit_GFX.h>    // Podstawowa biblioteka obsługująca grafikę
#include <Adafruit_ST7735.h> // Biblioteka obsługująca kontroler ST7735
#include <SPI.h>

// Zdefiniuj połączenia dla swojego panelu — będą one różne w zależności od wyświetlacza i płytki
#define TFT_CS   39
#define TFT_RST  37 
#define TFT_DC   38
#define TFT_BACKLIGHT  7
Adafruit_ST7735 tft = Adafruit_ST7735(TFT_CS, TFT_DC, TFT_RST);

void setup(void) 
{
  tft.initR(INITR_144GREENTAB); // Inicjalizacja chipa ST7735R, zielone oznaczenie na taśmie
  
  pinMode(TFT_BACKLIGHT, OUTPUT); // Pin podświetlenia
  digitalWrite(TFT_BACKLIGHT, HIGH); // Włączenie podświetlenia
  
  tft.setRotation(2); // Zależne od tego, jak zamontowałeś panel

  tft.fillScreen(ST77XX_BLACK); // Wypełnienie ekranu czarnym kolorem

  // Wyświetlenie różnego formatu tekstu (różne czcionki i rozmiary)
  tft.setCursor(0, 0);
  tft.setTextWrap(false);

  tft.setTextColor(ST77XX_RED);
  tft.setTextSize(1);
  tft.println("Mały");

  tft.setTextColor(ST77XX_GREEN);
  tft.setTextSize(2);
  tft.println("Średni");

  tft.setTextColor(ST77XX_BLUE);
  tft.setTextSize(3);
  tft.println("Duży");
}

int ballDir = 1;          // Aktualny kierunek ruchu
int ballDiameter = 8;     // Średnica kulki
int ballX = ballDiameter; // Początkowa pozycja x
void loop() 
{
  // Jeśli kulka zbliża się do brzegu ekranu, odwróć kierunek
  if (ballX >= tft.width() - ballDiameter || ballX < ballDiameter) {
    ballDir *= -1;
  }

  ballX += ballDir; // Zmiana pozycji x kulki

  // Obliczenie pozycji y na podstawie pozycji kursora
  int ballY = tft.getCursorY() + ballDiameter*2;

  tft.fillCircle(ballX, ballY, ballDiameter/2, 0xffff00); // Żółta kulka
  delay(25);
  tft.fillCircle(ballX, ballY, ballDiameter/2, 0x000000); // Usuwanie kulki z ekranu
}
