/*
 * Szkic oled
 * Wyświetla tekst i poruszającą się piłkę na wyświetlaczu OLED
 */

#include <SPI.h>
#include <Adafruit_GFX.h>
#include <Adafruit_SSD1306.h>

#define WIDTH 128
#define HEIGHT 32

#define OLED_DC     8
#define OLED_CS    10
#define OLED_RESET  9
Adafruit_SSD1306 display(WIDTH, HEIGHT, &SPI, OLED_DC, OLED_RESET, OLED_CS);

#define MODE SSD1306_SWITCHCAPVCC // Definicja napięcia wyświetlacza 3,3 V

void setup() 
{
  Serial.begin(9600);
  if(!display.begin(MODE)) 
  {
    Serial.println("Błąd inicjalizacji wyświetlacza");
    while(1); // Stop
  }

  showAndScroll("Mały",  1);
  showAndScroll("Średni", 2);
  showAndScroll("Duży",  3);
}

// Pokazanie i przewinięcie tekstu
void showAndScroll(String text, int textSize) 
{
  display.setTextColor(SSD1306_WHITE); // Rysowanie białego tekstu
  display.setCursor(0, 0); // Przesunięcie kursora na 0,0
  display.clearDisplay();  // Czyszczenie ekranu
  
  display.setTextSize(textSize);
  display.println(text);
  display.display();

  // Przewijanie ekranu w prawo przez 3 s
  display.startscrollright(0x00, 0x0F);
  delay(3000);
  display.stopscroll();
}

int ballDir = 1;            // Aktualny kierunek ruchu
int ballDiameter = 8;       // Średnica
int ballX = ballDiameter;   // Początkowa pozycja x
int ballY = ballDiameter*2; // Pozycja y

void loop() 
{
  display.clearDisplay();
  
  // Jeśli kulka zbliża się do brzegu ekranu, odwróć kierunek
  if (ballX >= WIDTH - ballDiameter || ballX < ballDiameter) 
  {
    ballDir *= -1;
  }

  // Zmiana pozycji x kulki
  ballX += ballDir;

  // Rysowanie kulki
  display.fillCircle(ballX, ballY, ballDiameter/2, SSD1306_INVERSE);
  display.display();
  delay(25);
  
  // Usunięcie kulki
  display.fillCircle(ballX, ballY, ballDiameter/2, SSD1306_INVERSE);
  display.display();
}
