/*
 * Szkic customchars_big
 * Szkic wyświetla cyfry dwa razy wyższe niż normalnie
 * Pomysł na tablicę bigDigit został zapożyczony od członka forum Arduino podpisującego się jako dcb
 */

#include <LiquidCrystal.h>

LiquidCrystal lcd(12, 11, 5, 4, 3, 2);

byte glyphs[5][8] = {
  { B11111,B11111,B00000,B00000,B00000,B00000,B00000,B00000 },
  { B00000,B00000,B00000,B00000,B00000,B00000,B11111,B11111 },
  { B11111,B11111,B00000,B00000,B00000,B00000,B11111,B11111 },
  { B11111,B11111,B11111,B11111,B11111,B11111,B11111,B11111 } ,
  { B00000,B00000,B00000,B00000,B00000,B01110,B01110,B01110 } };

const int digitWidth = 3; // Szerokość dużych znaków 
                          // (z wyłączeniem spacji pomiędzy znakami)

//Tablice z indeksami znaków specjalnych, z których zostaną złożone duże liczby
//Cyfry 0 - 4                             0      1       2      3      4
const char bigDigitsTop[10][digitWidth]={ 3,0,3, 0,3,32, 2,2,3, 0,2,3, 3,1,3,
// Cyfry 5-9                               5      6      7        8      9
                                          3,2,2, 3,2,2, 0,0,3,   3,2,3, 3,2,3};

const char bigDigitsBot[10][ digitWidth]={ 3,1,3, 1,3,1,  3,1,1, 1,1,3, 32,32,3,
                                           1,1,3, 3,1,3, 32,32,3, 3,1,3, 1,1,3};

char buffer[12]; // Bufor używany do zamiany liczby na łańcuch znaków
void setup ()
{
  lcd.begin(20,4);
  // Utworzenie znaku specjalnego
  for(int i=0; i < 5; i++)
    lcd.createChar(i, glyphs[i]); // Utworzenie pięciu znaków specjalnych
  // Pokazanie licznika (odliczanie w dół)
  for(int digit = 9; digit >= 0; digit--)
  {
    showDigit(digit, 0);  // Wyświetlenie cyfry
    delay(1000);
  }
  lcd.clear();
}

void loop ()
{
  // Pokazanie ile sekund upłynęło od początku działania szkicu
  int number = millis() / 1000;
  showNumber(number, 0);
  delay(1000);
  Serial.begin(9600);
}

void showDigit(int digit, int position)
{
  lcd.setCursor(position * (digitWidth + 1), 0);
  for(int i=0; i < digitWidth; i++)
    lcd.write(bigDigitsTop[digit][i]);
  lcd.setCursor(position * (digitWidth + 1), 1);
  for(int i=0; i < digitWidth; i++)
    lcd.write(bigDigitsBot[digit][i]);
}

void showNumber(int value, int position)
{
  int index; // Indeks cyfry, która ma być wyświetlona, 0 to pierwsza cyfra od lewej strony
  String valStr = String(value);

  // Wyświetlenie każdej cyfry po kolei
  for(index = 0; index < 5; index++) // wyświetlenie do pięciu cyfr
  {
    char c = valStr.charAt(index);
    if(c == 0)  // Sprawdzanie czy znak null (nie to samo co '0')
      return; // Ostatni znak łańcucha to null
    c = c - 48; // Zamiana wartości ASCII na wartość liczbową (zobacz rozdział 2.)
    showDigit(c, position + index);
  }
}
