/*
 * szkic customchar_pixel_advanced
 */

#include <LiquidCrystal.h>

LiquidCrystal lcd(12, 11, 5, 4, 3, 2);

//stałe przechowujące liczbę wierszy i kolumn wyświetlacza LCD
const int numRows = 2;
const int numCols = 16;

// tablica bitów definiujących stan pikseli dla 8 znaków specjalnych
// jedynki to piksel włączony, zera wyłączony

byte glyphs[8][8]  = {
      {B00000,B00000,B00000,B00000,B00000,B00000,B00000,B11111},   // 0
      {B00000,B00000,B00000,B00000,B00000,B00000,B11111,B11111},   // 1
      {B00000,B00000,B00000,B00000,B00000,B11111,B11111,B11111},   // 2
      {B00000,B00000,B00000,B00000,B11111,B11111,B11111,B11111},   // 3
      {B00000,B00000,B00000,B11111,B11111,B11111,B11111,B11111},   // 4
      {B00000,B00000,B11111,B11111,B11111,B11111,B11111,B11111},   // 5
      {B00000,B11111,B11111,B11111,B11111,B11111,B11111,B11111},   // 6
      {B11111,B11111,B11111,B11111,B11111,B11111,B11111,B11111}};  // 7

void setup ()
{
  lcd.begin(numCols, numRows);
  for(int i=0; i < 8; i++)
    lcd.createChar(i, glyphs[i]);     // tworzenie znaków specjalnych
  lcd.clear();
}

void loop ()
{
  for(int i=0; i < 16; i++)
  {
    int value = analogRead(A0);
    value = map(value, 0, 1023, 0,16);
    doubleHeightBars(value, i); // pokazanie wartości od 0 do 15
    delay(1000);  // jednosekundowa przerwa między odczytami
  }
}

void doubleHeightBars(int value, int column)
{
  char upperGlyph;
  char lowerGlyph;

  if(value < 8)
  {
    upperGlyph = ' ';  // wszystkie piksele wyłączone
    lowerGlyph = value;
  }
  else
  {
    upperGlyph = value - 8;
    lowerGlyph = 7; // wszystkie piksele włączone
  }

  lcd.setCursor(column, 0); // górna połowa
  lcd.write(upperGlyph);
  lcd.setCursor(column, 1); // dolna połowa
  lcd.write(lowerGlyph);
}
