/*
 * Szkic melody
 * Szkic grający melodię "Twinkle, Twinkle Little Star"
 * Głośnik jest podłączony do pinu 9
 */

const int speakerPin = 9; // Pin głośnika

char noteNames[] = {'C','D','E','F','G','a','b'};
unsigned int frequencies[] = {262,294,330,349,392,440,494};
const byte noteCount = sizeof(noteNames); // liczba nut (7)

//Nuty, spacja oznacza pauzę
char score[] = "CCGGaaGFFEEDDC GGFFEEDGGFFEED CCGGaaGFFEEDDC ";  
const byte scoreLen = sizeof(score); // Liczba nut w partyturze

void setup()
{
}

void loop()
{
  for (int i = 0; i < scoreLen; i++)
  {
    int duration = 333;  // Każda nuta trwa 1/3 sekundy
    playNote(score[i], duration); // Odtworzenie dźwięku
    delay(duration/10); // Krótka pauza między nutami
  }

  delay(4000); // Czekaj 4 s przed powtórzeniem piosenki
}

void playNote(char note, int duration)
{
  // Odtwórz dźwięk o częstotliwości odpowiadającej nazwie nuty
  for (int i = 0; i < noteCount; i++)
  {
    // Spróbuj znaleźć w tablicy noteNames odpowiednią nutę i uzyskać jej indeks
    if (noteNames[i] == note) // Szukanie pasującej nuty w tablicy
      tone(speakerPin, frequencies[i], duration); //  Odtworzenie dźwięku
  }
  // Jeśli nie odnaleziono nuty, oznacza to pauzę, więc wywołaj funkcję delay
  delay(duration);
}
