/*
   szkic stepper_bipolar_arduino_shield
   Silnik krokowy sterowany za pomocą poleceń z portu szeregowego
   Znak '+' lub '-' poprzedzony wartością liczbową obraca silnikiem.
*/

#include <Stepper.h>

// Zmień tą wartość na liczbę kroków Twojego silnika.
#define STEPS 64

// stworzenie instancji klasy Stepper z określeniem
// liczby kroków silnika i pinów, do których jest podłączony
Stepper stepper(STEPS, 12, 13);

int steps = 0;

void setup()
{
  pinMode(3, OUTPUT);
  digitalWrite(3, HIGH);   // włączenie pinu ENA

  pinMode(11, OUTPUT);
  digitalWrite(11, HIGH);   // włączenie pinu ENB
  
  stepper.setSpeed(60);   // ustawienie prędkości silnika na 60 rpm

  Serial.begin(9600);

}

void loop()
{
  if ( Serial.available())
  {
    char ch = Serial.read();

    if (isDigit(ch)) // Czy zmienna ch jest liczbą?
    {
      steps = steps * 10 + ch - '0'; // Jeżeli tak, sumuj wartości.
    }
    else if (ch == '+')
    {
      digitalWrite(3, HIGH);   // włączenie pinu ENA
      digitalWrite(11, HIGH);   // włączenie pinu ENB

      Serial.print("Ruch +"); Serial.println(steps);
      stepper.step(steps);
      steps = 0;
    }
    else if (ch == '-')
    {
      digitalWrite(3, HIGH);   // włączenie pinu ENA
      digitalWrite(11, HIGH);   // włączenie pinu ENB
      stepper.step(steps * -1);
      steps = 0;
    }
  }

  digitalWrite(3, LOW);   // wyłączenie pinu ENA
  digitalWrite(11, LOW);   // wyłączenie pinu ENB

}
