/*
 * Szkic sevenseg_mpx 
 * Pokazuje liczby z zakresu od 0 do 9999 na 4-cyfrowym wyświetlaczu
 * Ten przykład wyświetla wartości odczytane z czujnika podłączonego do analogowego pinu wejścia
 */

// Bity reprezentujące segmenty od A do G (i kropkę dziesiętną) dla cyfr 0-9
const int numeral[10] = {
  //ABCDEFG + kropka dziesiętna
  B11111100,  // 0
  B01100000,  // 1
  B11011010,  // 2
  B11110010,  // 3
  B01100110,  // 4
  B10110110,  // 5
  B00111110,  // 6
  B11100000,  // 7
  B11111110,  // 8
  B11100110,  // 9
};

// Piny dla kropki dziesiętnej i każdego segmentu
// Kropka dziesiętna,G,F,E,D,C,B,A
const int segmentPins[] = { 4, 7,8,6,5,3,2,9};

const int nbrDigits= 4;  // Liczba cyfr wyświetlacza
                             //Cyfry  0  1  2  3
const int digitPins[nbrDigits] = { 10,11,12,13};

void setup()
{
  for(int i=0; i < 8; i++)
    pinMode(segmentPins[i], OUTPUT); // Ustawienie pinów kropki dziesiętnej i segmentów jako wyjścia

  for(int i=0; i < nbrDigits; i++)
    pinMode(digitPins[i], OUTPUT);
}

void loop()
{
  int value = analogRead(0);
  showNumber(value);
}

void showNumber(int number)
{
  if(number == 0)
    showDigit( 0, nbrDigits-1) ; // Wyświetlenie 0 na pierwszej cyfrze od prawej strony 
  else
  {
    // Wyświetlenie wartości odpowiadającej każdej cyfrze
    // Pierwsza cyfra z lewej strony ma numer 0, pierwsza z prawej jest o jeden mniejsza niż liczba miejsc
    for( int digit = nbrDigits-1; digit >= 0; digit--)
    {
      if(number > 0)
      {
         showDigit( number % 10, digit)  ;
         number = number / 10;
      }
    }
  }
}

// Funkcja pokazująca podaną liczbę na wyświetlaczu 7-segmentowym na podanym miejscu
void showDigit( int number, int digit)
{
  digitalWrite( digitPins[digit], HIGH );
  for(int segment = 1; segment < 8; segment++)
  {
    bool isBitSet = bitRead(numeral[number], segment);    
    // isBitSet będzie równe true jeśli dany bit jest równy 1
    isBitSet = ! isBitSet; // Usuń tę linijkę, jeśli wyświetlacz ma wspólną katodę
    digitalWrite( segmentPins[segment], isBitSet);
  }
  delay(5);
  digitalWrite( digitPins[digit], LOW );
}
