/*
   Szkic pwm_PCA9685
   Efekt pływającego światła stworzony z wykorzystaniem diod LED podłączonych do wszystkich wyjść PCA9685
   Wersja dla jednego PCA9685 z podłączonymi 16 diodami LED
*/

#include <Wire.h>
#include <Adafruit_PWMServoDriver.h>

Adafruit_PWMServoDriver pwm = Adafruit_PWMServoDriver(); // Domyślny adres I2C to 0x40

void setup()
{
  pwm.begin(); // Inicjalizacja modułu I2C
}

int channel = 0;
int channel_direction = 1;
int intensity = 4095;       // Maksymalna jasność
int dim = intensity / 4;    // Jasność przyciemnionej diody LED 
  
void loop()
{
  channel += channel_direction; // Inkrementacja (lub dekrementacja) numeru kanału
  
  // Wyłączenie wszystkich pinów
  for (int pin = 0; pin < 16; pin++) {
    pwm.setPin(pin, 0);
  }

  // Jeśli doszliśmy do kanału 0, ustaw kierunek na 1
  if (channel == 0) {
    channel_direction = 1;
  }
  else { // Jeśli jesteśmy na kanale 1 lub wyższym, ustaw poprzdni na stan przyciemniony
    pwm.setPin(channel - 1, dim);
  }

  // Ustawienie na podanym kanale maksymalnej jasności
  pwm.setPin(channel, intensity);
  
  if (channel < 16) { // Jeśli jesteśmy poniżej kanału 16, ustaw kolejny kanał na stan przyciemniony
    pwm.setPin(channel + 1, dim);
  }
  else { // Jeśli doszliśmy do kanału 16, ustaw kierunek na -1
    channel_direction = -1;
  }

  delay(75);
}
