/*
 * szkic matrix_animation
 * Animacja dwóch obrazków serca ilustrująca bicie serca
 */

// Obrazki serc są przechowywane jako bitmapy — każdy bit odpowiada jednej diodzie LED
// 0 oznacza zgaszoną diodę, a 1 zapaloną
byte bigHeart[] = {
  B01100110,
  B11111111,
  B11111111,
  B11111111,
  B01111110,
  B00111100,
  B00011000,
  B00000000};

byte smallHeart[] = {
  B00000000,
  B00000000,
  B00010100,
  B00111110,
  B00111110,
  B00011100,
  B00001000,
  B00000000};

const int columnPins[] = { 2, 3, 4, 5, 6, 7, 8, 9};
const int rowPins[]    = {10,11,12,A1,A2,A3,A4,A5};

void setup() {
  for (int i = 0; i < 8; i++)
  {
    pinMode(rowPins[i], OUTPUT);        // Ustawienie wszystkich pinów diod LED jako wyjścia
    pinMode(columnPins[i], OUTPUT);
    digitalWrite(columnPins[i], HIGH);  // Odłączenie pinu kolumny od masy
  }
}

void loop() {
  int pulseDelay = 800 ; // Odstęp (w milisekundach) między kolejnymi uderzeniami serca 

  show(smallHeart, 80);  // Wyświetlenie małego serca przez 80 ms
  show(bigHeart, 160);   // Wyświetlenie dużego serca przez 160 ms
  delay(pulseDelay);     // Nie pokazuj nic między uderzeniami
}

// Wyświetlenie ramki obrazka przechowywanej w tablicy, której wskazaniem jest parametr obrazka
// Ramka jest powtarzana przez czas określony za pomocą drugiego parametru podanego w milisekundach

void show(byte * image, unsigned long duration)
{
 unsigned long start = millis();            // Początek odliczania czasu animacji
 while (start + duration > millis())        // Wykonuj tak długo, aż minie określony czas animacji
  {
    for(int row = 0; row < 8; row++)
    {
      digitalWrite(rowPins[row], HIGH);          // Podłączenie wiersza do napięcia
      for(int column = 0; column < 8; column++)
      {
        bool pixel = bitRead(image[row],column);
        if(pixel == 1)
        {
          digitalWrite(columnPins[column], LOW);  // Podłączenie kolumny do masy
        }
        delayMicroseconds(300);                   // Małe opóźnienie dla każdej diody LED
        digitalWrite(columnPins[column], HIGH);   // Odłączenie kolumny od masy
      }
      digitalWrite(rowPins[row], LOW);            // Odłączenie diod LED
    }
  }
}
