/*
 * Szkic nano_ble_sense
 * Demo czujników płytki Arduino Nano BLE Sense
 */

#include <Arduino_APDS9960.h>
#include <Arduino_HTS221.h>
#include <Arduino_LPS22HB.h>
#include <Arduino_LSM9DS1.h>

void setup() {
  
  Serial.begin(9600);
  while (!Serial);

  if (!APDS.begin()) { // Inicjalizacja czujnika gestu/koloru/odległości
    Serial.println("Błąd inicjalizacji APDS9960");
    while (1);
  }
  if (!HTS.begin()) {  // Inicjalizacja czujnika temperatury/wilgotności
    Serial.println("Błąd inicjalizacji HTS221");
    while (1);
  }
  if (!BARO.begin()) { // Inicjalizacja barometru
    Serial.println("Błąd inicjalizacji LPS22HB");
    while (1);
  }  
  if (!IMU.begin()) {  // Inicjalizacja jednostki do nawigacji inercyjnej (IMU)
    Serial.println("Błąd inicjalizacji LSM9DS1");
    while (1);
  }

  prompt(); // Powiedz użytkownikowi, co może zrobić
}

void loop() {

  // Jeśli wykryto gest, uruchom odpowiednią funkcję
  if (APDS.gestureAvailable()) {
    int gesture = APDS.readGesture();
    switch (gesture) {
      case GESTURE_UP:
        readTemperature();
        break;

      case GESTURE_DOWN:
        readHumidity();
        break;

      case GESTURE_LEFT:
        readPressure();
        break;

      case GESTURE_RIGHT:
        Serial.println("Pokręć żyroskopem!\nx, y, z");
        for (int i = 0; i < 10; i++)
        {
          readGyro();
          delay(250);
        }
        break;

      default:
        break;
    }
    prompt(); // Pokaż jeszcze raz podpowiedzi dla użytkownika
  }
}
void prompt() {
  Serial.println("\nPomachaj!");
  Serial.println("Unieś do góry, aby sprawdzić temperaturę, daj na dół, aby zmierzyć wilgotność.");
  Serial.println("Przesuwaj w lewo i w prawo, aby pobawić się żyroskopem.\n");
}

void readTemperature()
{
  float temperature = HTS.readTemperature(FAHRENHEIT);
  Serial.print("Temperatura: "); Serial.print(temperature);
  Serial.println(" °F");
}

void readHumidity() 
{
  float humidity = HTS.readHumidity();
  Serial.print("Wilgotność: "); Serial.print(humidity);
  Serial.println(" %");
}

void readPressure() 
{
  float pressure = BARO.readPressure(PSI);
  Serial.print("Ciśnienie: "); Serial.print(pressure);
  Serial.println(" psi");
}

void readGyro() 
{
  float x, y, z;
  if (IMU.gyroscopeAvailable()) {
    IMU.readGyroscope(x, y, z);
    Serial.print(x); Serial.print(", ");
    Serial.print(y); Serial.print(", ");
    Serial.println(z);
  }
}
