/* szkic PN532_SPI
 *  Czytnik NFC - SPI
 * Odczytuje etykietę NFC i wyświetla jej unikalny numer identyfikacyjny.
 */
 
#include <SPI.h>
#include <NfcAdapter.h>
#include <PN532/PN532/PN532.h>
#include <PN532/PN532_SPI/PN532_SPI.h>

PN532_SPI pn532spi(SPI, 10);
NfcAdapter nfc = NfcAdapter(pn532spi);

void setup() 
{
  Serial.begin(9600);
  nfc.begin(); // inicjalizacja czytnika NFC
}

void loop() 
{
  Serial.println("Czekanie na zbliżenie etykiety do czytnika");
  if (nfc.tagPresent()) //  Jeśli czytnik widzi naklejkę NFC,
  {
    NfcTag tag = nfc.read(); // odcztuje ją
    Serial.println(tag.getUidString()); // i wyświetla jej ID.
  }
  delay(500);
}
